#pragma once

#include "yp_cluster_data.h"

#include <infra/libs/yp_dns/zone/protos/config.pb.h>
#include <infra/libs/yp_dns/record_set/record_set.h>

#include <infra/contrib/pdns/power_dns/dnsname.hh>

#include <library/cpp/threading/future/async.h>

#include <util/folder/path.h>
#include <util/generic/hash.h>
#include <util/thread/pool.h>

namespace NYpDns::NGenerateZoneFiles {

class TZone {
public:
    TZone(TZoneConfig config, IThreadPool& pool);

    NThreading::TFuture<void> Load();

    NThreading::TFuture<void> GenerateZoneFile(const TFsPath& outputDir);

private:
    void AddRecordSetReplicaIfBelongs(const TString& clusterName, const TSerializedRecordSet& recordSetReplica);

private:
    const TZoneConfig Config_;
    const DNSName Name_;

    THashMap<TString, TYpClusterDataRef> ClusterDatas_;
    THashMap<TString, TVector<TSerializedRecordSet>> RecordSetsReplicas_;

    TMutex InitMutex_;
    NThreading::TFuture<void> InitFuture_;

    IThreadPool& Pool_;
};

TVector<TZone> CreateZones(const TVector<TZoneConfig>& zoneConfigs, IThreadPool& threadPool);

} // namespace NYpDns::NGenerateZoneFiles
