import argparse
import logging
import os

from infra.yp_dns.tools.handle_duplicate_records.lib.handle_duplicate_records import handle_duplicate_records
from yp.client import YpClient


def parse_args():
    parser = argparse.ArgumentParser(description='Finds and removes duplicates of records in dns_record_sets of the specified YP cluster')
    parser.add_argument('-c', '--cluster', required=True,
                        choices=['sas-test', 'sas', 'man-pre', 'man', 'vla', 'myt', 'iva', 'xdc'],
                        help='YP cluster name')
    parser.add_argument('-r', '--remove', action='store_true',
                        help='Should also remove duplicates')
    parser.add_argument('-l', '--limit', type=int,
                        help='Max number of record sets to update')
    parser.add_argument('-d', '--delay', type=int, default=0,
                        help='Seconds between updates')
    parser.add_argument('-v', '--verbose', action='store_true',
                        help='Set DEBUG for logging level')
    return parser.parse_args()


def main():
    args = parse_args()

    logging.basicConfig(level=(logging.DEBUG if args.verbose else logging.INFO))

    yp_client = YpClient(address='{}.yp.yandex.net:8090'.format(args.cluster), config={'token': os.environ['YP_TOKEN']})

    handle_duplicate_records(yp_client, args.remove, args.limit, args.delay)
