#pragma once

#include <infra/yp_dns_api/bridge/api/api.grpc.pb.h>
#include <infra/yp_dns_api/bridge/service_iface/api.h>

#include <infra/libs/yp_dns/dynamic_zones/zones_manager_service/api/api.pb.h>
#include <infra/libs/yp_dns/dynamic_zones/zones_manager_service/client/client.h>

#include <contrib/libs/grpc/include/grpc++/channel.h>
#include <contrib/libs/grpc/include/grpc++/create_channel.h>

#include <util/datetime/base.h>
#include <util/generic/strbuf.h>
#include <util/generic/yexception.h>

#include <chrono>

namespace NInfra::NYpDnsApi {

int RunClient(int argc, const char* argv[]);

class TClient: public IApi {
public:
    TClient(const TStringBuf address, const TDuration timeout = TDuration::Seconds(80));

    void Ping(TRequestPtr<NApi::TReqPing>, TReplyPtr<NApi::TRspPing>) override;

    void UpdateRecords(TRequestPtr<NApi::TReqUpdateRecords> request, TReplyPtr<NApi::TRspUpdateRecords> reply) override;

    void ListZoneRecordSets(TRequestPtr<NApi::TReqListZoneRecordSets> request, TReplyPtr<NApi::TRspListZoneRecordSets> reply) override;

    void ListZones(TRequestPtr<NYpDns::NDynamicZones::NApi::TReqListZones> request, TReplyPtr<NYpDns::NDynamicZones::NApi::TRspListZones> reply) override;

    void CreateZone(TRequestPtr<NYpDns::NDynamicZones::NApi::TReqCreateZone> request, TReplyPtr<NYpDns::NDynamicZones::NApi::TRspCreateZone> reply) override;

    void RemoveZone(TRequestPtr<NYpDns::NDynamicZones::NApi::TReqRemoveZone> request, TReplyPtr<NYpDns::NDynamicZones::NApi::TRspRemoveZone> reply) override;

private:
    template <typename TRequest, typename TReply, typename TCallback>
    void GrpcRequest(TRequestPtr<TRequest> request, TReplyPtr<TReply> reply, TCallback&& callback) {
        TReply result;

        grpc::ClientContext context;
        context.set_deadline(std::chrono::system_clock::now() + std::chrono::milliseconds(Timeout_.MilliSeconds()));

        if (grpc::Status status = ((*Stub_).*callback)(&context, request->Get(), &result); !status.ok()) {
            ythrow yexception() << TStringBuf("\nCode: ") << static_cast<ui64>(status.error_code()) << TStringBuf("\nMessage: ") << status.error_message();
        }

        reply->Set(result);
    }

private:
    std::shared_ptr<grpc::Channel> Channel_;
    std::shared_ptr<NApi::TYpDnsApiBridgeService::Stub> Stub_;

    const TDuration Timeout_;

    NYpDns::NDynamicZones::TRawZonesManagerServiceClient ZonesManagerServiceClient_;
};

} // namespace NInfra::NYpDnsApi
