#include "main.h"

#include <infra/yp_dns_api/bridge/config/config.pb.h>
#include <infra/yp_dns_api/bridge/service/service.h>

#include <infra/libs/sensors/sensor_registry.h>

#include <mapreduce/yt/common/config.h>
#include <mapreduce/yt/interface/logging/logger.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/json_writer.h>
#include <library/cpp/logger/global/global.h>
#include <library/cpp/proto_config/config.h>
#include <library/cpp/proto_config/load.h>
#include <library/cpp/protobuf/json/proto2json.h>

namespace NInfra::NYpDnsApi {

void PrettyPrintConfig(const TBridgeConfig& config) {
    NJson::TJsonValue configJson;
    TStringStream str{NProtobufJson::Proto2Json(config)};
    INFO_LOG << "Config:\n" << NJson::WriteJson(NJson::ReadJsonTree(&str, /* allowComments */ false, /* throwOnError */ true), /* formatOutput */ true) << Endl;
}

void InitEnvironment() {
    // NYT::SetLogger(NYT::CreateStdErrLogger(NYT::ILogger::INFO));
    NYT::TConfig::Get()->WaitLockPollInterval = TDuration::MilliSeconds(500);
}

int RunDaemon(const TBridgeConfig& config) {
    InitGlobalLog2Console(TLOG_DEBUG);
    PrettyPrintConfig(config);
    InitEnvironment();

    NInfra::SetSensorRegistryCommonGroup({"bridge"});

    TService service(config);
    service.Start();
    service.Wait();
    return EXIT_SUCCESS;
}

int RunDaemon(NProtoConfig::TLoadConfigOptions& options) {
    const TBridgeConfig config = NProtoConfig::LoadWithOptions<TBridgeConfig>(options);

    return RunDaemon(config);
}

int RunDaemon(int argc, const char* argv[]) {
    const TBridgeConfig config = NProtoConfig::GetOpt<TBridgeConfig>(argc, argv, "/proto_config/bridge_config.json");

    return RunDaemon(config);
}

int RunDaemon(const TStringBuf configJson) {
    const TBridgeConfig config = NProtoConfig::ParseConfigFromJson<TBridgeConfig>(configJson);

    return RunDaemon(config);
}

} // namespace NInfra::NYpDnsApi
