#include "server.h"

namespace NInfra::NYpDnsApi {

TGrpcServer::TGrpcServer(const TGrpcServiceConfig& config, IService& service)
    : GrpcService_(service)
    , ServerAddress_("0.0.0.0:" + ToString(config.GetPort())) // https://st.yandex-team.ru/DTCC-695
{
    ServerBuilder_.AddListeningPort(ServerAddress_, grpc::InsecureServerCredentials());
    for (grpc::Service* grpcService : GrpcService_.Services()) {
        ServerBuilder_.RegisterService(grpcService);
    }
}

TGrpcServer::~TGrpcServer() {
    try {
        Stop();
    } catch (...) {
        // ¯\_(ツ)_/¯
    }
}

void TGrpcServer::Start(TLogFramePtr logFrame) {
    Server_ = ServerBuilder_.BuildAndStart();
    logFrame->LogEvent(NLogEvent::TStartService("grpc", ToString(ServerAddress_)));
}

void TGrpcServer::Wait(TLogFramePtr logFrame) {
    {
        TGuard<TMutex> guard(Mutex_);

        while (!Shutdown_) {
            CondVar_.Wait(Mutex_);
        }
    }

    Stop();
    logFrame->LogEvent(NLogEvent::TStopService("grpc"));
}

void TGrpcServer::Stop() {
    if (Server_) {
        Server_->Shutdown();
        Server_->Wait();
    }
}

void TGrpcServer::Shutdown() {
    TGuard<TMutex> guard(Mutex_);

    if (!Shutdown_) {
        Shutdown_ = true;

        CondVar_.Signal();
    }
}

} // namespace NInfra::NYpDnsApi
