#pragma once

#include "service.h"

#include <infra/yp_dns_api/bridge/config/config.pb.h>
#include <infra/yp_dns_api/bridge/service_iface/service_iface.h>

#include <infra/libs/logger/log_frame.h>

#include <contrib/libs/grpc/include/grpc++/grpc++.h>

#include <util/system/condvar.h>
#include <util/system/mutex.h>

#include <string>

namespace NInfra::NYpDnsApi {

class TGrpcServer {
public:
    TGrpcServer(const TGrpcServiceConfig& config, IService& service);
    ~TGrpcServer();

    void Start(TLogFramePtr logFrame);

    void Stop();

    void Wait(TLogFramePtr logFrame);

    void Shutdown();

private:
    TGrpcService GrpcService_;
    // https://st.yandex-team.ru/DTCC-695
    TString ServerAddress_;
    grpc::ServerBuilder ServerBuilder_;
    std::unique_ptr<grpc::Server> Server_;

    TMutex Mutex_;
    TCondVar CondVar_;
    bool Shutdown_;
};

} // namespace NInfra::NYpDnsApi
