#include "service.h"

#include <type_traits>

namespace NInfra::NYpDnsApi {

namespace {

template <typename TService, typename = std::enable_if_t<std::is_base_of_v<TService, TGrpcService>>>
TService* CastService(TGrpcService* service) {
    return dynamic_cast<TService*>(service);
}

} // anonymous namespace

TGrpcService::TGrpcService(IService& service)
    : Service_(service)
{
}

using Status = grpc::Status;

TVector<grpc::Service*> TGrpcService::Services() {
    TVector<grpc::Service*> result;
    result.emplace_back(CastService<NApi::TYpDnsApiBridgeService::Service>(this));
    result.emplace_back(CastService<NYpDns::NDynamicZones::NApi::TZonesManagerService::Service>(this));
    return result;
}

Status TGrpcService::Ping(ServerContext* ctx, const NApi::TReqPing* request, NApi::TRspPing* response) {
    return Call(ctx, request, response, [this](const auto& request, auto& reply) { Service_.Ping(request, reply); });
}

Status TGrpcService::UpdateRecords(ServerContext* ctx, const NApi::TReqUpdateRecords* request, NApi::TRspUpdateRecords* response) {
    return Call(ctx, request, response, [this](const auto& request, auto& reply) { Service_.UpdateRecords(request, reply); });
}

Status TGrpcService::ListZoneRecordSets(ServerContext* ctx, const NApi::TReqListZoneRecordSets* request, NApi::TRspListZoneRecordSets* response) {
    return Call(ctx, request, response, [this](const auto& request, auto& reply) { Service_.ListZoneRecordSets(request, reply); });
}

Status TGrpcService::ListZones(ServerContext* ctx, const NYpDns::NDynamicZones::NApi::TReqListZones* request, NYpDns::NDynamicZones::NApi::TRspListZones* response) {
    return Call(ctx, request, response, [this](const auto& request, auto& reply) { Service_.ListZones(request, reply); });
}

Status TGrpcService::CreateZone(ServerContext* ctx, const NYpDns::NDynamicZones::NApi::TReqCreateZone* request, NYpDns::NDynamicZones::NApi::TRspCreateZone* response) {
    return Call(ctx, request, response, [this](const auto& request, auto& reply) { Service_.CreateZone(request, reply); });
}

Status TGrpcService::RemoveZone(ServerContext* ctx, const NYpDns::NDynamicZones::NApi::TReqRemoveZone* request, NYpDns::NDynamicZones::NApi::TRspRemoveZone* response) {
    return Call(ctx, request, response, [this](const auto& request, auto& reply) { Service_.RemoveZone(request, reply); });
}
 
} // namespace NInfra::NYpDnsApi
