#pragma once

#include <infra/yp_dns_api/bridge/api/api.grpc.pb.h>
#include <infra/yp_dns_api/bridge/service_iface/service_iface.h>

#include <infra/libs/yp_dns/dynamic_zones/zones_manager_service/api/api.grpc.pb.h>

#include <infra/libs/service_iface/str_iface.h>

#include <contrib/libs/grpc/include/grpc++/grpc++.h>

namespace NInfra::NYpDnsApi {

class TGrpcService:
    // TODO(dima-zakharov): Clean up the mess with multiple inheritance
    public NApi::TYpDnsApiBridgeService::Service,
    public NYpDns::NDynamicZones::NApi::TZonesManagerService::Service
{
public:
    using Status = grpc::Status;
    using ServerContext = grpc::ServerContext;

public:
    TGrpcService(IService& service);

    TVector<grpc::Service*> Services();

    Status Ping(ServerContext*, const NApi::TReqPing* request, NApi::TRspPing* response) override;

    Status UpdateRecords(ServerContext*, const NApi::TReqUpdateRecords* request, NApi::TRspUpdateRecords* response) override;

    Status ListZoneRecordSets(ServerContext*, const NApi::TReqListZoneRecordSets* request, NApi::TRspListZoneRecordSets* response) override;

    Status ListZones(ServerContext*, const NYpDns::NDynamicZones::NApi::TReqListZones* request, NYpDns::NDynamicZones::NApi::TRspListZones* response) override;

    Status CreateZone(ServerContext*, const NYpDns::NDynamicZones::NApi::TReqCreateZone* request, NYpDns::NDynamicZones::NApi::TRspCreateZone* response) override;

    Status RemoveZone(ServerContext*, const NYpDns::NDynamicZones::NApi::TReqRemoveZone* request, NYpDns::NDynamicZones::NApi::TRspRemoveZone* response) override;

private:
    template <class TRequest, class TReply, class TCallback>
    Status Call(ServerContext* ctx, const TRequest* request, TReply* reply, TCallback&& callback) {
        try {
            TAttributes attributes;
            for (const auto& [key, value] : ctx->client_metadata()) {
                attributes.insert({TString(key.data(), key.size()), TString(value.data(), value.size())});
            }
            attributes.emplace(NServiceAttributes::RemoteAddressAttributeName(), ctx->peer());

            TRequestPtr<TRequest> requestPtr(new TProtoRequest<TRequest>(TStringBuf(), *request, attributes));
            TAttributes responseAttributes;
            TReplyPtr<TReply> replyPtr(new TProtoReply<TReply>(*reply, responseAttributes));
            callback(requestPtr, replyPtr);
            return Status::OK;
        } catch (const TAccessDeniedError& ex) {
            return Status(grpc::StatusCode::UNAUTHENTICATED, std::string(CurrentExceptionMessage().data()));
        } catch (const TServiceError& ex) {
            return Status(ex.GetGrpcStatusCode(), std::string(CurrentExceptionMessage().data()));
        } catch (...) {
            return Status(grpc::StatusCode::INTERNAL, std::string(CurrentExceptionMessage().data()));
        }
    }

private:
    IService& Service_;
};

} // namespace NInfra::NYpDnsApi
