#pragma once

#include <infra/yp_dns_api/bridge/api/api.pb.h>
#include <infra/yp_dns_api/bridge/logger/events/events_decl.ev.pb.h>
#include <infra/yp_dns_api/bridge/misc/record_request.h>

#include <infra/libs/service_iface/str_iface.h>
#include <infra/libs/yp_dns/record_set/record_set.h>
#include <infra/libs/yp_replica/yp_replica.h>

#include <yp/yp_proto/yp/client/api/proto/data_model.pb.h>
#include <yp/cpp/yp/client.h>

#include <library/cpp/json/json_writer.h>

namespace NInfra::NYpDnsApi {

TString AttributesToString(const TAttributes& attributes);

NEventlog::NBridge::TDnsRecord MakeRecordEvent(const NYP::NClient::NApi::NProto::TDnsRecordSetSpec::TResourceRecord& record);

NEventlog::NBridge::TDnsRecord MakeRecordEvent(const NApi::TRecord& record);

google::protobuf::RepeatedPtrField<NEventlog::NBridge::TDnsRecord> MakeRecordsEvent(const google::protobuf::RepeatedPtrField<NYP::NClient::NApi::NProto::TDnsRecordSetSpec::TResourceRecord>& records);

template <typename TEvent>
TEvent MakeRecordSetEvent(const NYpDns::TRecordSet& recordSet) {
    TEvent event;
    event.SetFqdn(recordSet.Meta().id());
    if (const TMaybe<TString>& zone = recordSet.Zone(); zone.Defined()) {
        event.SetZone(*zone);
    }
    *event.MutableRecords() = MakeRecordsEvent(recordSet.Spec().records());
    if (recordSet.HasChangelist()) {
        event.SetChangelist(NJson::WriteJson(recordSet.Changelist().ToJson(), /* formatOutput */ false));
    }
    return event;
}

NEventlog::NBridge::TUpdateRecordRequest MakeUpdateRecordRequestEvent(const TRecordRequest& request);

NEventlog::NBridge::TRemoveRecordRequest MakeRemoveRecordRequestEvent(const TRecordRequest& request);

NEventlog::NBridge::TUpdateRecordResponse MakeUpdateRecordResponseEvent(const TRecordRequest& request);

NEventlog::NBridge::TRemoveRecordResponse MakeRemoveRecordResponseEvent(const TRecordRequest& request);

NEventlog::NBridge::TYpGetRecordSetsRequest MakeYpGetRecordSetsRequestEvent(NYP::NClient::TClientPtr client, const TVector<TString>& ids, const TVector<TString>& selectors);

NEventlog::NBridge::TListZoneRecordSetsRequest MakeListZoneRecordSetsRequestEvent(const TRequestPtr<NApi::TReqListZoneRecordSets> request);

NEventlog::NBridge::TListZoneRecordSetsResponse MakeListZoneRecordSetsResponseEvent(const NApi::TRspListZoneRecordSets& response);

NEventlog::NBridge::TListZoneRecordSetResponse MakeListZoneRecordSetResponseEvent(const NApi::TRecordSet& recordSet);

NEventlog::NBridge::TSeekOptions MakeSeekOptionsEvent(const NYP::NYPReplica::TYPReplica<NYP::NYPReplica::TDnsRecordSetReplicaObject>::TListOptions<NYP::NYPReplica::TDnsRecordSetReplicaObject>& listOptions);

NEventlog::NBridge::TListZoneRecordSetsFromReplicaRequest MakeListZoneRecordSetsFromReplicaRequestEvent(
    const NYP::NYPReplica::TYPReplica<NYP::NYPReplica::TDnsRecordSetReplicaObject>& replica,
    const DNSName& zone,
    const NYP::NYPReplica::TYPReplica<NYP::NYPReplica::TDnsRecordSetReplicaObject>::TListOptions<NYP::NYPReplica::TDnsRecordSetReplicaObject>& listOptions
);

NEventlog::NBridge::TListZoneRecordSetsFromYPRequest MakeListZoneRecordSetsFromYPRequestEvent(
    const TStringBuf cluster,
    const DNSName& zone,
    const NYP::NYPReplica::TYPReplica<NYP::NYPReplica::TDnsRecordSetReplicaObject>::TListOptions<NYP::NYPReplica::TDnsRecordSetReplicaObject>& listOptions
);

NEventlog::NBridge::TYpSelectZoneRecordSetsRequest MakeYpSelectZoneRecordSetsRequestEvent(
    const ui64 timestamp,
    const DNSName& zone,
    const NYP::NYPReplica::TYPReplica<NYP::NYPReplica::TDnsRecordSetReplicaObject>::TListOptions<NYP::NYPReplica::TDnsRecordSetReplicaObject>& listOptions
);

} // namespace NInfra::NYpDnsApi
