#pragma once

#include "types.h"

#include <infra/yp_dns_api/bridge/config/config.pb.h>

#include <infra/libs/updatable_proto_config/accessor.h>

namespace NInfra::NYpDnsApi {

class TBannedClustersForMethod {
public:
    TBannedClustersForMethod(
        const TBannedClustersConfig& initialConfig,
        int bannedClustersConfigFieldTagId);

    void OnConfigUpdate(
        const TBannedClustersConfig& oldConfig,
        const TBannedClustersConfig& newConfig
    );

    bool IsBanned(const TClusterId& cluster) const;

private:
    NProtoBuf::RepeatedFieldRef<TString> GetBannedClusters(const TBannedClustersConfig& config) const;

private:
    const NProtoBuf::FieldDescriptor* BannedClustersConfigFieldDescriptor_;

    TRWMutex Lock_;
    THashSet<TClusterId> Banned_;
};

class TBannedClusters {
public:
    TBannedClusters(NUpdatableProtoConfig::TAccessor<TBannedClustersConfig> config);

    bool IsBannedForUpdateRecords(const TClusterId& cluster) const;
    bool IsBannedForListZoneRecordSets(const TClusterId& cluster) const;

private:
    NUpdatableProtoConfig::TAccessor<TBannedClustersConfig> Config_;

    TBannedClustersForMethod BannedForUpdateRecords_;
    TBannedClustersForMethod BannedForListZoneRecordSets_;
};

} // namespace NInfra::NYpDnsApi
