#include "find_zone.h"

namespace NInfra::NYpDnsApi {

const TZoneConfig* DetectZone(const TZoneConfigs& zoneConfigs, const TDynamicZones& dynamicZones, const DNSName& domain) {
    for (const auto& [zoneName, zoneConfig] : zoneConfigs) {
        if (domain.isPartOf(zoneName)) {
            return &zoneConfig;
        }
    }
    for (const auto& [zoneName, zoneConfig] : dynamicZones) {
        if (domain.isPartOf(zoneName)) {
            return &zoneConfig;
        }
    }
    return nullptr;
}

const TZoneConfig* FindZone(const TZoneConfigs& zoneConfigs, const TDynamicZones& dynamicZones, const DNSName& domain) {
    for (const auto& [zoneName, zoneConfig] : zoneConfigs) {
        if (domain == zoneName) {
            return &zoneConfig;
        }
    }
    return dynamicZones.FindPtr(domain);
}

} // namespace NInfra::NYpDnsApi
