#pragma once

#include <infra/yp_dns_api/bridge/config/config.pb.h>

#include <infra/libs/yp_dns/zone/zone.h>

#include <infra/contrib/pdns/power_dns/dnsname.hh>

#include <util/generic/vector.h>

template <>
struct THash<DNSName> {
    size_t operator()(const DNSName& name) const {
        return name.hash();
    }
};

namespace NInfra::NYpDnsApi {

using TZoneConfigs = TVector<std::pair<DNSName, const TZoneConfig>>;

using TDynamicZones = THashMap<DNSName, TZoneConfig>;
using TDynamicZonesPtr = TAtomicSharedPtr<TDynamicZones>;

const TZoneConfig* DetectZone(const TZoneConfigs& zoneConfigs, const TDynamicZones& dynamicZones, const DNSName& domain);

const TZoneConfig* FindZone(const TZoneConfigs& zoneConfigs, const TDynamicZones& dynamicZones, const DNSName& domain);

} // namespace NInfra::NYpDnsApi
