#pragma once

#include "find_zone.h"

#include <infra/yp_dns_api/bridge/api/api.pb.h>
#include <infra/yp_dns_api/bridge/config/config.pb.h>

#include <infra/contrib/pdns/power_dns/dnsname.hh>

namespace NInfra::NYpDnsApi {

struct TRecordRequest {
    TRecordRequest(const NApi::TRecordRequest& request, const TZoneConfigs& zoneConfigs, const TDynamicZones& dynamicZones);

    void SetRspStatus(
        NApi::TRspUpdateRecord::EUpdateRecordStatus updateStatus,
        NApi::TRspRemoveRecord::ERemoveRecordStatus removeStatus,
        const TString& errorMessage = {},
        const TString& cluster = {}
    );

    void SetRspOkStatus(const TString& cluster);

    void SetRspUnknownZoneStatus();

    void SetRspYpErrorStatus(const TString& errorMessage, const TString& cluster);

    void SetRspValidationErrorStatus(const TString& errorMessage, const TString& cluster);

    void SetRspInvalidHintStatus(const TString& HintCluster);

    void SetRspClusterBannedStatus(const TString& cluster);

    void SetRspZoneUpdatesDisabledStatus();

    void SetRspRequestThrottledStatus(const TString& cluster, const ui64 changesPerMinute);

    void SetRspChangelistOverflowStatus(const TString& cluster, const ui64 size);

    DNSName Fqdn;
    const TZoneConfig* ZoneConfig = nullptr;
    const NApi::TRecordRequest* Request = nullptr;
    NApi::TRecordResponse Response;
    bool Commited = false;
};

} // namespace NInfra::NYpDnsApi
