#include "router_api.h"

#include <infra/libs/version_handle/version_handle.h>
#include <infra/libs/yp_dns/dynamic_zones/zones_manager_service/router_api/router_api.h>

#include <infra/libs/service_iface/str_iface.h>

namespace NInfra::NYpDnsApi {

using TRequestRouterPtr = TSimpleSharedPtr<NInfra::TRequestRouter<IApi>>;

TRequestRouterPtr AddAdminRoutes(TRequestRouterPtr router) {
    (*router)
        .Add<TEmptyRequest<NApi::TReqPing>, TProto2JsonReply<NApi::TRspPing>>("/ping", "Ping", &IApi::Ping)
        .Add<TEmptyRequest<NApi::TReqReopenLog>, TEmptyReply<NApi::TRspReopenLog>>("/reopen_log", "Reopen log", &IApi::ReopenLog)
        .Add<TEmptyRequest<NApi::TReqShutdown>, TEmptyReply<NApi::TRspShutdown>>("/shutdown", "Shutdown", &IApi::Shutdown)
        .Add<TEmptyRequest<NApi::TReqSensors>, TRawDataReply<NApi::TRspSensors>>("/sensors", "Show sensors", &IApi::Sensors);
    
    return router;  
}

TRequestRouterPtr AddBridgeRoutes(TRequestRouterPtr router) {
    (*router)
        .Add<TEmptyRequest<NApi::TReqPing>, TProto2JsonReply<NApi::TRspPing>>("/ping", "Ping", &IApi::Ping)
        .Add<TSerializedProtoRequest<NApi::TReqUpdateRecords>, TSerializedProtoReply<NApi::TRspUpdateRecords>>("/records/update", "Update record", &IApi::UpdateRecords)
        .Add<TJson2ProtoRequest<NApi::TReqUpdateRecords>, TProto2JsonReply<NApi::TRspUpdateRecords>>("/records/update/json", "Update record (json)", &IApi::UpdateRecords)
        .Add<TSerializedProtoRequest<NApi::TReqListZoneRecordSets>, TSerializedProtoReply<NApi::TRspListZoneRecordSets>>("/list_zone_record_sets", "List zone record sets", &IApi::ListZoneRecordSets)
        .Add<TJson2ProtoRequest<NApi::TReqListZoneRecordSets>, TProto2JsonReply<NApi::TRspListZoneRecordSets>>("/list_zone_record_sets/json", "List zone record sets (json)", &IApi::ListZoneRecordSets);
    
    return router;
}

NInfra::TRequestRouterPtr CreateAdminRouter(IApi& service) {
    auto router = AddAdminRoutes(MakeSimpleShared<TRequestRouter<IApi>>(service));
    NInfra::NVersionHandle::AddBinaryHandlers(*router);

    return router;
}

NInfra::TRequestRouterPtr CreateBridgeRouter(IApi& service) {
    auto router = AddBridgeRoutes(MakeSimpleShared<TRequestRouter<IApi>>(service));
    NYpDns::NDynamicZones::AddZonesManagerHandlers(*router);

    return router;
}

} // namespace NInfra::NYpDnsApi
