#pragma once

#include <infra/libs/lifetime_histogram/lifetime_histogram.h>

#include <util/generic/strbuf.h>

namespace NInfra::NYpDnsApi::NSensors {

constexpr TStringBuf SERVICE_GROUP = "service";

constexpr TStringBuf PING_REQUESTS = "ping";
constexpr TStringBuf REOPEN_LOG_REQUESTS = "reopen_log";
constexpr TStringBuf SHUTDOWN_REQUESTS = "shutdown";
constexpr TStringBuf SENSORS_REQUESTS = "sensors";

constexpr TStringBuf REQUESTS = "requests";
constexpr TStringBuf ERRORS = "errors";
constexpr TStringBuf FAILURES = "failures";
constexpr TStringBuf SUCCESSES = "successes";

constexpr TStringBuf UPDATE_RECORDS = "update_records";
constexpr TStringBuf UPDATE_RECORD = "update_record";
constexpr TStringBuf REMOVE_RECORD = "remove_record";

constexpr TStringBuf LIST_ZONE_RECORD_SETS = "list_zone_record_sets";

constexpr TStringBuf LIST_ZONES = "list_zones";
constexpr TStringBuf CREATE_ZONE = "create_zone";
constexpr TStringBuf REMOVE_ZONE = "remove_zone";

constexpr TStringBuf FIND_RECORD_SETS = "find_record_sets";
constexpr TStringBuf GET_RECORD_SETS = "get_record_sets";

constexpr TStringBuf FROM_YP = "from_yp";
constexpr TStringBuf FROM_REPLICA = "from_replica";

constexpr TStringBuf FALLBACK_TO_YP = "fallback_to_yp";
constexpr TStringBuf FALLBACK_TO_REPLICA = "fallback_to_replica";

constexpr TStringBuf UPDATE_RECORD_SET = "update_record_set";

constexpr TStringBuf YP_CREATE_RECORD_SETS = "yp.create_record_sets";
constexpr TStringBuf YP_UPDATE_RECORD_SETS = "yp.update_record_sets";
constexpr TStringBuf YP_REMOVE_RECORD_SETS = "yp.remove_record_sets";

constexpr TStringBuf YP_START_TRANSACTION = "yp.start_transaction";
constexpr TStringBuf YP_COMMIT_TRANSACTION = "yp.commit_transaction";
constexpr TStringBuf YP_GET_RECORD_SETS = "yp.get_record_sets";
constexpr TStringBuf YP_GENERATE_TIMESTAMP = "yp.generate_timestamp";
constexpr TStringBuf YP_SELECT_ZONE_RECORD_SETS = "yp.select_zone_record_sets";

constexpr TStringBuf STATUS = "status";

constexpr std::initializer_list<double> DEFAULT_BUCKET_BOUNDS = {
    100, 500, 1000, 5000, 1e4, 4e4, 7e4,
    1e5, 2e5, 3e5, 4e5, 5e5, 6e5, 7e5, 8e5, 9e5,                // [100ms, 1000ms) +100ms
    1e6, 1.5e6, 2e6, 2.5e6, 3e6, 3.5e6, 4e6, 4.5e6,             // [1s, 5s) + 0.5s
    5e6, 6e6, 7e6, 8e6, 9e6,                                    // [5s, 10s) + 1s
    1e7, 1.5e7, 2e7, 2.5e7, 3e7, 3.5e7, 4e7, 4.5e7, 5e7,
    5.5e7, 6e7, 6.5e7, 7e7, 7.5e7, 8e7, 8.5e7, 9e7, 9.5e7, 1e8  // [10s, 100s] +5s
};

constexpr std::initializer_list<std::pair<NLifetimeHistogram::EResponseSizeType, ui64>> NOSIZE_RESPONSE_SIZES = {{NLifetimeHistogram::EResponseSizeType::NOSIZE, 0}};
constexpr std::initializer_list<std::pair<NLifetimeHistogram::EResponseSizeType, ui64>> LIST_ZONE_RECORD_SET_RESPONSE_SIZES = {
    {NLifetimeHistogram::EResponseSizeType::SMALL,  500},
    {NLifetimeHistogram::EResponseSizeType::MEDIUM, 5000},
    {NLifetimeHistogram::EResponseSizeType::LARGE,  0},
};

constexpr std::initializer_list<std::tuple<TStringBuf, std::initializer_list<double>, std::initializer_list<std::pair<NLifetimeHistogram::EResponseSizeType, ui64>>>> RESPONSE_TIME_HISTOGRAM_INIT_PARAMETERS = {
    {UPDATE_RECORDS,          DEFAULT_BUCKET_BOUNDS, NOSIZE_RESPONSE_SIZES},
    {LIST_ZONE_RECORD_SETS,   DEFAULT_BUCKET_BOUNDS, LIST_ZONE_RECORD_SET_RESPONSE_SIZES},
    {LIST_ZONES,              DEFAULT_BUCKET_BOUNDS, NOSIZE_RESPONSE_SIZES},
    {CREATE_ZONE,             DEFAULT_BUCKET_BOUNDS, NOSIZE_RESPONSE_SIZES},
    {REMOVE_ZONE,             DEFAULT_BUCKET_BOUNDS, NOSIZE_RESPONSE_SIZES},
};

} // namespace NInfra::NYpDnsApi::NSensors
