#pragma once

#include <infra/yp_dns_api/bridge/api/api.pb.h>
#include <infra/yp_dns_api/bridge/api/internal.pb.h>

#include <infra/libs/version_handle/version_handle.h>
#include <infra/libs/yp_dns/dynamic_zones/zones_manager_service/service_iface/api.h>

#include <infra/libs/service_iface/errors.h>
#include <infra/libs/service_iface/reply.h>
#include <infra/libs/service_iface/request.h>
#include <infra/libs/service_iface/router.h>

namespace NInfra::NYpDnsApi {

class IApi : public NYpDns::NDynamicZones::IZonesManagerApi, public NVersionHandle::TBinaryApi {
public:
    virtual ~IApi() = default;

    virtual void Ping(TRequestPtr<NApi::TReqPing>, TReplyPtr<NApi::TRspPing>) {
        ythrow TNotImplementedError();
    }

    virtual void ReopenLog(TRequestPtr<NApi::TReqReopenLog>, TReplyPtr<NApi::TRspReopenLog>) {
        ythrow TNotImplementedError();
    }

    virtual void Shutdown(TRequestPtr<NApi::TReqShutdown>, TReplyPtr<NApi::TRspShutdown>) {
        ythrow TNotImplementedError();
    }

    virtual void Sensors(TRequestPtr<NApi::TReqSensors>, TReplyPtr<NApi::TRspSensors>) {
        ythrow TNotImplementedError();
    }

    virtual void UpdateRecords(TRequestPtr<NApi::TReqUpdateRecords>, TReplyPtr<NApi::TRspUpdateRecords>) {
        ythrow TNotImplementedError();
    }

    virtual void ListZoneRecordSets(TRequestPtr<NApi::TReqListZoneRecordSets>, TReplyPtr<NApi::TRspListZoneRecordSets>) {
        ythrow TNotImplementedError();
    }
};

} // namespace NInfra::NYpDnsApi
