#include <infra/yp_dns_api/bridge/daemon/main.h>
#include <infra/yp_dns_api/bridge/client/client.h>

#include <infra/yp_dns_api/replicator/daemon/main.h>
#include <infra/yp_dns_api/replicator/sync_zone/main.h>

#include <infra/yp_dns_api/replicator_shard_master/libs/daemon/main.h>

#include <infra/libs/logger/log_printer.h>

#include <library/cpp/getopt/small/modchooser.h>

#include <util/generic/yexception.h>
#include <util/stream/output.h>
#include <util/system/backtrace.h>

int main(int argc, const char* argv[]) {
    TModChooser modChooser;

    modChooser.AddMode("bridge",
                       NInfra::NYpDnsApi::RunDaemon,
                       "Run yp_dns api bridge daemon.");

    modChooser.AddMode("bridge_client",
                       NInfra::NYpDnsApi::RunClient,
                       "Run yp_dns api bridge client.");

    modChooser.AddMode("replicator",
                       NInfra::NYpDnsApi::NReplicator::RunDaemon,
                       "Run yp_dns api replicator daemon.");

    modChooser.AddMode("sync_zone",
                       NInfra::NYpDnsApi::NReplicator::SyncZone,
                       "Synchronize zone over clusters.");

    modChooser.AddMode("replicator_shard_master",
                       NInfra::NYpDnsApi::NReplicator::NShardMaster::RunDaemon,
                       "Run yp_dns api replicator_shard_master daemon.");

    modChooser.AddMode("print_log",
                       NInfra::PrintEventLog,
                       "Print eventlog.");
    try {
        return modChooser.Run(argc, argv);
    } catch (...) {
        Cerr << CurrentExceptionMessage() << Endl;
        TBackTrace::FromCurrentException().PrintTo(Cerr);
        return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}
