#include "aggregate_objects.h"
#include <yp/yp_proto/yp/client/api/proto/autogen.pb.h>

#include <infra/yp_dns_api/libs/yp/clients_registry.h>
#include <infra/yp_dns_api/libs/yp/execute.h>
#include <infra/yp_dns_api/libs/yp/protos/events/events_decl.ev.pb.h>

#include <yp/cpp/yp/response_model.h>
#include <yp/cpp/yp/selector_result.h>

namespace NInfra::NYpDnsApi {

namespace {

NEventlog::TAggregateObjectsArgument MakeAggregateObjectsArgumentEvent(const TAggregateObjectsArgument& arg) {
    NEventlog::TAggregateObjectsArgument result;
    result.SetCluster(arg.Cluster);
    result.SetObjectType(NYP::NClient::NApi::NProto::EObjectType_Name(arg.ObjectType));
    result.MutableGroupByExpressions()->Reserve(arg.GroupByExpressions.size());
    for (const TString& expr : arg.GroupByExpressions) {
        result.AddGroupByExpressions(expr);
    }
    result.MutableAggregateExpressions()->Reserve(arg.AggregateExpressions.size());
    for (const TString& expr : arg.AggregateExpressions) {
        result.AddAggregateExpressions(expr);
    }
    result.SetFilter(arg.Filter);
    return result;
}

} // anonymous namespace

////////////////////////////////////////////////////////////////////////////////

TAggregateObjectsResult AggregateObjects(
    const NYP::NClient::TClientPtr client,
    const TAggregateObjectsArgument& arg,
    NInfra::TLogFramePtr logFrame
) {
    Y_UNUSED(logFrame);
    Y_ENSURE(client->Options().SnapshotTimestamp() > 0);

    logFrame->LogEvent(NEventlog::TAggregateObjects(client->Options().Address(), MakeAggregateObjectsArgumentEvent(arg)));
    TAggregateObjectsResult result = AggregateObjects(
        client,
        arg.ObjectType,
        arg.GroupByExpressions,
        arg.AggregateExpressions,
        arg.Filter,
        /* timestamp */ 0,
        logFrame
    );

    logFrame->LogEvent(NEventlog::TAggregateObjectsResult(client->Options().Address(), result.size()));

    return result;
}

TAggregateObjectsResults AggregateObjects(
    const TYpClientsRegistry& clientsRegistry,
    const TAggregateObjectsArguments& args,
    NInfra::TLogFramePtr logFrame
) {
    TAggregateObjectsResults result;
    result.reserve(args.size());
    for (const TAggregateObjectsArgument& arg : args) {
        result.emplace_back(AggregateObjects(clientsRegistry.Get(arg.Cluster), arg, logFrame));
    }
    return result;
}

////////////////////////////////////////////////////////////////////////////////

} // namespace NInfra::NYpDnsApi
