#pragma once

#include "clients_registry.h"

#include <infra/libs/logger/log_frame.h>

#include <yp/cpp/yp/client.h>
#include <yp/cpp/yp/selector_result.h>

namespace NInfra::NYpDnsApi {

struct TAggregateObjectsArgument {
    TString Cluster;
    NYP::NClient::NApi::NProto::EObjectType ObjectType;
    TVector<TString> GroupByExpressions;
    TVector<TString> AggregateExpressions;
    TString Filter;
};

using TAggregateObjectsArguments = TVector<TAggregateObjectsArgument>;

using TAggregateObjectsResult = TVector<NYP::NClient::TSelectorResult>;

using TAggregateObjectsResults = TVector<TAggregateObjectsResult>;

////////////////////////////////////////////////////////////////////////////////

TAggregateObjectsResult AggregateObjects(
    const NYP::NClient::TClientPtr client,
    const TAggregateObjectsArgument& arg,
    NInfra::TLogFramePtr logFrame
);

TAggregateObjectsResults AggregateObjects(
    const TYpClientsRegistry& clientsRegistry,
    const TAggregateObjectsArguments& args,
    NInfra::TLogFramePtr logFrame
);

////////////////////////////////////////////////////////////////////////////////

} // namespace NInfra::NYpDnsApi