#pragma once

#include <yp/cpp/yp/client.h>

namespace NInfra::NYpDnsApi {

////////////////////////////////////////////////////////////////////////////////

struct TClusterOptions {
    TString Name;
    TString Address;
    bool EnableSsl = true;
    bool ReadOnly = false;
    TDuration Timeout = TDuration::Seconds(30);

    TString Token;
};

////////////////////////////////////////////////////////////////////////////////

class TYpClientsRegistry: private THashMap<TString, NYP::NClient::TClientPtr> {
public:
    using TBase = THashMap<TString, NYP::NClient::TClientPtr>;

    using TBase::reserve;

    TYpClientsRegistry(NYP::NClient::TClientOptions defaultClientOptions);

    std::pair<NYP::NClient::TClientPtr, bool> Register(const TClusterOptions& clusterOptions);

    NYP::NClient::TClientPtr Get(const TString& key) const;

    TYpClientsRegistry CreateSnapshot(const THashMap<TString, ui64>& timestamps = {}) const;

private:
    std::pair<NYP::NClient::TClientPtr, bool> Register(const TString& key, NYP::NClient::TClientPtr client);

private:
    const NYP::NClient::TClientOptions DefaultClientOptions_;
};

////////////////////////////////////////////////////////////////////////////////

} // namespace NInfra::NYpDnsApi
