#pragma once

#include <infra/libs/logger/log_frame.h>

#include <yp/cpp/yp/client.h>
#include <yp/cpp/yp/error.h>

#include <library/cpp/retry/retry.h>

namespace NInfra::NYpDnsApi {

template <typename TResult>
TResult ExecuteYpRequest(const std::function<TResult()>& requestFunc, const std::function<void(const NYP::NClient::TResponseError&)>& onError) {
    return *DoWithRetry<TResult, NYP::NClient::TResponseError>(
        requestFunc,
        onError,
        TRetryOptions().WithCount(3)
                       .WithSleep(TDuration::MilliSeconds(250))
                       .WithIncrement(TDuration::MilliSeconds(250)),
        /* throwLast = */ true
    );
}

void ExecuteYpRequest(const std::function<void()>& requestFunc, const std::function<void(const NYP::NClient::TResponseError&)>& onError);

////////////////////////////////////////////////////////////////////////////////

ui64 GenerateTimestamp(NYP::NClient::TClientPtr client);

////////////////////////////////////////////////////////////////////////////////

NYP::NClient::TSelectObjectsResult SelectObjects(
    NYP::NClient::TClientPtr client,
    NYP::NClient::NApi::NProto::EObjectType objectType,
    const TVector<TString>& selectors,
    const TString& filter = {},
    const NYP::NClient::TSelectObjectsOptions& options = {},
    const ui64 timestamp = 0,
    NInfra::TLogFramePtr logFrame = nullptr
);

////////////////////////////////////////////////////////////////////////////////

TVector<NYP::NClient::TSelectorResult> AggregateObjects(
    NYP::NClient::TClientPtr client,
    NYP::NClient::NApi::NProto::EObjectType objectType,
    const TVector<TString>& groupByExpressions,
    const TVector<TString>& aggregateExpressions,
    const TString& filter = {},
    const ui64 timestamp = 0,
    NInfra::TLogFramePtr logFrame = nullptr
);

////////////////////////////////////////////////////////////////////////////////

} // namespace NInfra::NYpDnsApi
