#pragma once

#include "clients_registry.h"

#include <infra/yp_dns_api/libs/yp/protos/events/events_decl.ev.pb.h>

#include <infra/libs/controller/object_manager/object_manager.h>
#include <infra/libs/logger/log_frame.h>

#include <yp/client/api/misc/public.h>

#include <yp/cpp/yp/request_model.h>
#include <yp/cpp/yp/selector_result.h>
#include <yp/cpp/yp/update_request.h>

namespace NInfra::NYpDnsApi {

struct TGetObjectsArgument {
    TString Cluster;
    NYP::NClient::NApi::NProto::EObjectType ObjectType;
    TVector<TString> Selectors;
    TString Filter;
    TMaybe<ui64> Limit;
    TMaybe<ui64> TotalLimit;
};

using TGetObjectsArguments = TVector<TGetObjectsArgument>;

using TGetObjectsResult = NYP::NClient::TSelectObjectsResult;

using TGetObjectsResults = TVector<TGetObjectsResult>;

////////////////////////////////////////////////////////////////////////////////

NEventlog::TGetObjectsArgument MakeGetObjectsArgumentEvent(const NController::IObjectManager::TSelectArgument& arg);

////////////////////////////////////////////////////////////////////////////////

TGetObjectsResult GetObjects(const NYP::NClient::TClientPtr client, const TGetObjectsArgument& arg, NInfra::TLogFramePtr logFrame);

TGetObjectsResults GetObjects(const TYpClientsRegistry& clientsRegistry, const TGetObjectsArguments& args, NInfra::TLogFramePtr logFrame);

////////////////////////////////////////////////////////////////////////////////

} // namespace NInfra::NYpDnsApi
