import os
from datetime import datetime

import solomon


SOLOMON_PROD_URL = "http://solomon.yandex.net"


class SolomonClient(solomon.BasePushApiReporter):
    JSON_HEADERS = {
        'Content-Type': 'application/json',
    }

    def __init__(
        self,
        project,
        cluster,
        service,
        solomon_token=None
    ):
        super(SolomonClient, self).__init__(
            project=project,
            cluster=cluster,
            service=service,
            url=SOLOMON_PROD_URL,
            auth_provider=solomon.OAuthProvider(solomon_token or os.getenv("SOLOMON_TOKEN"))
        )
        self.reset_timestamp()

    def reset_timestamp(self):
        self._ts_datetime = datetime.utcnow()

    def set_value(self, sensor, value, labels=None, is_derived=None):
        if isinstance(sensor, list):
            ts_datetime = [self._ts_datetime] * len(sensor)
        else:
            ts_datetime = self._ts_datetime
        super(SolomonClient, self).set_value(sensor, value, labels, is_derived, ts_datetime)
