import grpc

from infra.yp_dns_api.bridge.api import api_pb2
from infra.yp_dns_api.bridge.api import api_pb2_grpc

from infra.libs.yp_dns.dynamic_zones.zones_manager_service.api import api_pb2 as zm_api_pb2
from infra.libs.yp_dns.dynamic_zones.zones_manager_service.api import api_pb2_grpc as zm_api_pb2_grpc


class YpDnsApiBridgeClient(object):
    def __init__(self, grpc_address, credentials=None, options=None):
        if credentials is None:
            self._channel = grpc.insecure_channel(grpc_address, options)
        else:
            self._channel = grpc.secure_channel(grpc_address, credentials, options)
        self._stub = api_pb2_grpc.TYpDnsApiBridgeServiceStub(self._channel)
        self._zm_stub = zm_api_pb2_grpc.TZonesManagerServiceStub(self._channel)

    def update_records(self, update_records_request, timeout=None):
        request = update_records_request

        response = self._stub.UpdateRecords.future(request, timeout=timeout)
        return response.result()

    def list_zone_record_sets(self, zone, limit=None, continuation_token=None, timeout=None):
        request = api_pb2.TReqListZoneRecordSets()
        request.zone = zone
        if limit is not None:
            request.limit = limit
        if continuation_token is not None:
            request.continuation_token = continuation_token

        response = self._stub.ListZoneRecordSets.future(request, timeout=timeout)
        return response.result()

    def list_zones(self, service_type, timeout=None):
        request = zm_api_pb2.TReqListZones()
        request.service_type = service_type

        response = self._zm_stub.ListZones.future(request, timeout=timeout)
        return response.result()

    def create_zone(self, zone_config, timeout=None):
        request = zm_api_pb2.TReqCreateZone()
        request.zone.config.CopyFrom(zone_config)

        response = self._zm_stub.CreateZone.future(request, timeout=timeout)
        return response.result()

    def remove_zone(self, zone_id, timeout=None):
        request = zm_api_pb2.TReqRemoveZone()
        request.zone_id = zone_id

        response = self._zm_stub.RemoveZone.future(request, timeout=timeout)
        return response.result()
