#include "config_validator.h"

#include <util/string/builder.h>
#include <util/generic/hash_set.h>

namespace NInfra::NYpDnsApi::NReplicator::NConfigValidator {

void ValidateShardsZonesDistribution(const NInfra::NYpDnsApi::NReplicator::TShardsZonesDistributionConfig& config) {
    const size_t numberOfShards = config.GetShardsConfig().GetNumberOfShards();
    const auto& zonesCoverageConfig = config.GetZonesCoverage();

    Y_ENSURE(
        numberOfShards == zonesCoverageConfig.GetNumberOfCommonShards() + zonesCoverageConfig.GetSpecificZonesShards().size(),
        TStringBuilder{} << "Total shards: " << numberOfShards
            << ", Common shards: " << zonesCoverageConfig.GetNumberOfCommonShards()
            << ", Specific shards: " << zonesCoverageConfig.GetSpecificZonesShards().size()
    );

    THashSet<TString> specificZones;
    for (const auto& specificZonesShard : zonesCoverageConfig.GetSpecificZonesShards()) {
        for (const auto& zone : specificZonesShard.GetListOfZones()) {
            Y_ENSURE(specificZones.emplace(zone).second);
        }
    }
}

} // namespace NInfra::NYpDnsApi::NReplicator::NConfigValidator
