#include "main.h"

#include <infra/yp_dns_api/replicator/config/config.pb.h>
#include <infra/yp_dns_api/replicator/config_validator/config_validator.h>
#include <infra/yp_dns_api/replicator/zone_replicator/factory.h>

#include <infra/libs/controller/config/config.pb.h>
#include <infra/libs/controller/daemon/main.h>
#include <infra/libs/controller/object_manager/object_manager.h>
#include <infra/libs/logger/logger.h>

#include <library/cpp/proto_config/load.h>

namespace NInfra::NYpDnsApi::NReplicator {

int RunDaemon(const TReplicatorConfig& config) {
    NConfigValidator::ValidateShardsZonesDistribution(config.GetShardsZonesDistribution());
    const size_t numberOfShards = config.GetShardsZonesDistribution().GetShardsConfig().GetNumberOfShards();
    NInfra::NController::TSharding shardsFactory(config.GetController().GetLeadingInvader(), {}, numberOfShards);

    TVector<NController::TObjectManagersFactoryPtr> objectFactories = CreateZoneReplicatorsFactories(
        TVector<TZonesReplicationConfig>(config.GetZonesReplicationConfigs().begin(), config.GetZonesReplicationConfigs().end())
        , shardsFactory
        , config.GetShardsZonesDistribution().GetZonesCoverage()
    );

    const NUpdatableProtoConfig::TConfigHolderConfig& updatableConfigOpts = config.GetController().GetUpdatableConfigOptions();
    NUpdatableProtoConfig::TConfigHolderPtr<TReplicatorConfig> configHolder = NUpdatableProtoConfig::CreateConfigHolder(config, updatableConfigOpts);

    return NController::RunDaemon<NController::TService>(
        configHolder->Accessor<NController::TControllerConfig>("Controller"),
        objectFactories
    );
}

int RunDaemon(int argc, const char* argv[]) {
    const TReplicatorConfig config = NProtoConfig::GetOpt<TReplicatorConfig>(argc, argv, "/proto_config/replicator_config.json");

    return RunDaemon(config);
}

} // namespace NInfra::NYpDnsApi::NReplicator
