#pragma once

#include <infra/yp_dns_api/replicator/zone_replicator/protos/config/config.pb.h>

#include <infra/yp_dns_api/libs/yp/get_objects.h>

#include <infra/libs/controller/object_manager/object_manager.h>
#include <infra/libs/logger/log_frame.h>
#include <infra/libs/yp_dns/record_set/record_set.h>
#include <infra/libs/yp_dns/replication/merge.h>

#include <yp/cpp/yp/request_model.h>
#include <yp/cpp/yp/update_request.h>

#include <util/generic/vector.h>

namespace NInfra::NYpDnsApi::NReplicator {

class TZoneReplicator: public NController::IObjectManager {
public:
    TZoneReplicator(TZoneReplicatorConfig config, THashMap<TString, TVector<NYpDns::TSerializedRecordSet>> zoneRecordSets);

    TString GetObjectId() const override;

    TVector<IObjectManager::TSelectArgument> GetDependentObjectsSelectArguments() const override;

    void GenerateYpUpdates(
        const TDependentObjects& dependentObjects
        , THashMap<TString, TVector<TRequest>>& requests
        , TLogFramePtr frame
    ) const override;

private:
    const TZoneReplicatorConfig Config_;
    const THashMap<TString, TVector<NYpDns::TSerializedRecordSet>> ZoneRecordSets_;
    TVector<TSelectArgument>  GetDependentObjectsArguments_;
};

} // namespace NInfra::NYpDnsApi::NReplicator
