#include "main.h"

#include <infra/yp_dns_api/replicator_shard_master/libs/config/config.pb.h>

#include <infra/libs/controller/shard_master/daemon/main.h>

namespace NInfra::NYpDnsApi::NReplicator::NShardMaster {

int RunDaemon(int argc, const char* argv[]) {
    NInfra::SetSensorRegistryCommonGroup({"shard_master"});

    const TConfig config = NProtoConfig::GetOpt<TConfig>(argc, argv, "/proto_config/config.json");
    const NUpdatableProtoConfig::TConfigHolderConfig& updatableConfigOpts = config.GetShardMaster().GetUpdatableConfigOptions();

    NUpdatableProtoConfig::TConfigHolderPtr<TConfig> configHolder = NUpdatableProtoConfig::CreateConfigHolder(config, updatableConfigOpts);

    TVector<NController::NShardMaster::TDistributionManagerPtr> distributionManagers;
    distributionManagers.reserve(1);
    distributionManagers.emplace_back(
        new NController::NShardMaster::TDistributionManager(
            configHolder->Accessor<NController::NShardMaster::TDistributionManagerConfig>("YpDnsApiReplicator")
    ));

    return RunDaemon<NController::NShardMaster::TService>(
        configHolder->Accessor<NController::NShardMaster::TConfig>("ShardMaster"),
        std::move(distributionManagers));
}

} // namespace NInfra::NYpDnsApi::NReplicator::NShardMaster
