import argparse

from yp.client import YpClient, find_token


def parse_args():
    parser = argparse.ArgumentParser(description='Clears changelists for every record set in '
                                                 'specified zone')

    parser.add_argument('-c', '--cluster', required=True,
                        choices=['sas-test', 'sas', 'man-pre', 'man', 'vla', 'myt', 'iva', 'xdc'],
                        help='YP cluster name')
    parser.add_argument('-z', '--zone', required=True)
    return parser.parse_args()


def main():
    args = parse_args()

    yp_client = YpClient(address='{}.yp.yandex.net:8090'.format(args.cluster), config={'token': find_token()})

    continuation_token = None
    update_requests = []
    while True:
        timestamp = yp_client.generate_timestamp()

        limit = 10000
        result = yp_client.select_objects('dns_record_set', filter='[/labels/zone] = "{}" and [/labels/changelist/0] != #'.format(args.zone),
                                          selectors=['/meta/id', '/labels/changelist'], timestamp=timestamp, limit=limit,
                                          options={'continuation_token': continuation_token}, enable_structured_response=True)
        continuation_token = result['continuation_token']

        for id, _ in result['results']:
            update_requests.append({
                'object_type': 'dns_record_set',
                'object_id': id["value"],
                'set_updates': [
                    {
                        'path': '/labels/changelist',
                        'value': [],
                    },
                ],
            })

        if len(result['results']) < limit:
            break

    print('total updates: {}'.format(len(update_requests)))

    batch_size = 10000
    for i in range(0, len(update_requests), batch_size):
        reqs = update_requests[i:min(len(update_requests), i + batch_size)]
        print('record sets to update: {}'.format(len(reqs)))
        yp_client.update_objects(reqs)
