import logging
import sys

from yp.client import YpClient, find_token


if __name__ == '__main__':
    logging.basicConfig(level=logging.INFO)

    cluster = sys.argv[1]
    logging.info('YP cluster: {}'.format(cluster))

    zone = sys.argv[2]
    logging.info('Zone: {}'.format(zone))

    yp_client = YpClient(cluster, config={"token": find_token()})

    limit = 10000
    continuation_token = None
    to_remove = []

    while True:
        result = yp_client.select_objects(
            'dns_record_set',
            selectors=['/meta/id'],
            filter='[/labels/zone] = "{}"'.format(zone),
            limit=limit,
            options={'continuation_token': continuation_token},
            enable_structured_response=True,
        )
        continuation_token = result['continuation_token']
        to_remove += list(map(lambda obj: obj[0]['value'], result['results']))
        if len(result['results']) < limit:
            break

    logging.info('{} selected'.format(len(to_remove)))

    deleted = 0
    batch_size = 1000
    for idx in range(0, len(to_remove), batch_size):
        batch = to_remove[idx:idx + batch_size]
        yp_client.remove_objects([('dns_record_set', obj_id) for obj_id in batch])
        # logging.info([('dns_record_set', obj_id) for obj_id in batch])
        deleted += len(batch)
        logging.info('{} / {}'.format(deleted, len(to_remove)))

    logging.info('removed')
