#include <infra/libs/yp_dns/dynamic_zones/helpers/yt/yt.h>
#include <infra/libs/yp_dns/zone/zone.h>

#include <infra/libs/logger/logger.h>

#include <mapreduce/yt/interface/fwd.h>
#include <mapreduce/yt/interface/client.h>

#include <yp/cpp/yp/client.h>
#include <yp/cpp/yp/token.h>

#include <library/cpp/json/json_writer.h>
#include <library/cpp/protobuf/json/proto2json.h>
#include <library/cpp/yson/node/node_io.h>

using namespace NYpDns;
using namespace NYpDns::NYtHelpers;

const TString ZONES_CPATH = "//home/yp-dns/yp-dns-api-bridge/dynamic_zones/zones";

void Migrate() {
    NInfra::TLogger logger{NInfra::TLoggerConfig()};
    NInfra::TLogFramePtr logFrame = logger.SpawnFrame();
    NYT::IClientPtr ytClient = NYT::CreateClient("yp-xdc");
    TVector<NYT::TNode> zonesNodes = ListNodesData(ytClient, ZONES_CPATH, logFrame);

    NYP::NClient::TClientPtr ypClient = NYP::NClient::CreateClient(
        NYP::NClient::TClientOptions()
            .SetAddress("xdc")
            .SetTimeout(TDuration::Seconds(10))
            .SetToken(NYP::NClient::FindToken())
    );
    for (const auto& node : zonesNodes) {
        Cerr << "found zone in YT:" << Endl
             << NYT::NodeToYsonString(node) << Endl;

        auto currentState = node["data"]["state"]["current_state"];
        auto targetState = node["data"]["state"]["target_state"];
        if (currentState == "NOT_EXIST" && targetState == "NOT_EXIST") {
            continue;
        }

        TZone zone(node["data"]["config"]);
        auto object = zone.ConfigToYpDnsZoneObject();
        auto& acl = *object.MutableMeta()->add_acl();
        acl.set_action(NYP::NClient::NApi::NProto::EAccessControlAction::ACA_ALLOW);
        acl.add_subjects("robot-ydnxdns-export");
        acl.add_subjects("robot-ypdnsapi");
        acl.add_subjects("robot-ypdnsapi-repl");
        acl.add_permissions(NYP::NClient::NApi::NProto::EAccessControlPermission::ACP_READ);
        acl.add_permissions(NYP::NClient::NApi::NProto::EAccessControlPermission::ACA_WRITE);
        (*object.MutableLabels())["state"]["current_state"] = currentState.AsString();
        (*object.MutableLabels())["state"]["target_state"] = targetState.AsString();

        NProtobufJson::TProto2JsonConfig cfg;
        cfg.SetEnumMode(NProtobufJson::TProto2JsonConfig::EnumName);
        Cerr << "create zone " << zone.GetName() << Endl
            << "meta = " << NProtobufJson::Proto2Json(object.Meta(), cfg) << Endl
            << "spec = " << NProtobufJson::Proto2Json(object.Spec(), cfg) << Endl
            << "status = " << NProtobufJson::Proto2Json(object.Status(), cfg) << Endl
            << "labels = " << NJson::WriteJson(object.Labels(), false) << Endl;
        ypClient->CreateObject(object).GetValue(ypClient->Options().Timeout() * 2);
    }
}

int main() {
    Migrate();
}
