#!/bin/bash

set -ex

# What does this script do?
# Deletes write access for dns_record_sets for Bridge robot.
# Waits for 5 min for Replicator to do his job.
# Gives write access back.

# How to run?
# 0. Read the script.
# 1. Set actual zones list.
# 2. Remove -d (dry run) from ./set_acl command args to actually run.
# 3. Set YP_TOKEN of user who has write access for objects.

zones=("0.0.0.0.4.0.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "0.0.1.0.3.0.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "0.0.2.0.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "0.0.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "0.0.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "0.1.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "0.1.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "1.1.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "1.1.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "2.0.1.0.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "2.0.2.0.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "2.0.3.0.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "2.1.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "2.1.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "3.1.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "3.1.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "4.0.1.0.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "4.1.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "4.1.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "5.0.1.0.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "5.0.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "5.0.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "5.1.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "5.1.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "6.1.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "6.1.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "7.0.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "7.1.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "7.1.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "8.0.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "8.0.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "8.1.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "8.1.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "9.0.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "9.1.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "9.1.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "a.0.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "a.0.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "a.1.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "a.1.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "b.0.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "b.0.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "b.1.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "b.1.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "c.0.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "c.0.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "c.1.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "c.1.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "d.0.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "d.0.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "d.1.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "e.0.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "f.0.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "f.0.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "e.1.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "d.1.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "e.1.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "f.1.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "0.2.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "0.2.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "f.1.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "1.2.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "1.2.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "2.2.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "4.2.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "3.2.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "4.2.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "3.2.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "5.2.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "5.2.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "6.2.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "6.2.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "7.2.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "7.2.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "a.2.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "8.2.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "a.2.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "2.2.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "c.2.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "9.2.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "b.2.c.0.8.b.6.0.2.0.a.2.ip6.arpa" "b.2.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "9.2.c.f.8.b.6.0.2.0.a.2.ip6.arpa" "8.2.c.0.8.b.6.0.2.0.a.2.ip6.arpa")

for zone in "${zones[@]}"; do
    for cluster in sas man vla; do
        echo $zone $cluster
        YP_TOKEN='AQAD-XXXX' ./set_acl -v -z $zone -c $cluster -x robot-ypdnsapi -d || exit 1
    done
done

sleep 300

for zone in "${zones[@]}"; do
    for cluster in sas man vla; do
        echo $zone $cluster
        YP_TOKEN='AQAD-XXXX' ./set_acl -v -z $zone -c $cluster -u robot-ypdnsapi -d || exit 1
    done
done
