#include <infra/yp_dns_updates_coordinator/libs/daemon/main.h>
#include <infra/yp_dns_updates_coordinator/libs/update_timestamp/update_timestamp.h>

#include <infra/libs/logger/log_printer.h>

#include <library/cpp/getopt/modchooser.h>

#include <util/generic/yexception.h>
#include <util/stream/output.h>

int main(int argc, const char* argv[]) {
    TModChooser modChooser;

    modChooser.AddMode("run",
                       NYpDnsUpdatesCoordinator::RunDaemon,
                       "Run YP DNS Updates Coordinator daemon.");

    modChooser.AddMode("print_log",
                       NInfra::PrintEventLog,
                       "Run udp_click_metrics eventlog.");

    modChooser.AddMode("update_timestamp",
                       NYpDnsUpdatesCoordinator::UpdateTimestamp,
                       "Update location target timestamp.");

    try {
        return modChooser.Run(argc, argv);
    } catch (...) {
        Cerr << CurrentExceptionMessage() << Endl;
        return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}
