#include "main.h"

#include <infra/libs/yp_updates_coordinator/service/service.h>

#include <infra/libs/sensors/sensor_registry.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/json_writer.h>
#include <library/cpp/proto_config/load.h>
#include <library/cpp/protobuf/json/proto2json.h>

namespace NYpDnsUpdatesCoordinator {

void PrettyPrintConfig(const NYPUpdatesCoordinator::TServiceConfig& config) {
    NJson::TJsonValue configJson;
    TStringStream str{NProtobufJson::Proto2Json(config)};
    Cout << NJson::WriteJson(NJson::ReadJsonTree(&str, /* allowComments */ false, /* throwOnError */ true), /* formatOutput */ true) << Endl;
}

int RunDaemon(const NYPUpdatesCoordinator::TServiceConfig& config) {
    PrettyPrintConfig(config);

    NInfra::SetSensorRegistryCommonGroup({"yp_dns_updates_coordinator"});

    NYPUpdatesCoordinator::TService service(config);
    service.Start();
    service.Wait();

    return EXIT_SUCCESS;
}

int RunDaemon(int argc, const char* argv[]) {
    const NYPUpdatesCoordinator::TServiceConfig config = NProtoConfig::GetOpt<NYPUpdatesCoordinator::TServiceConfig>(argc, argv, "/yp_dns_updates_coordinator/config.json");
    return RunDaemon(config);
}

} // namespace NYpDnsUpdatesCoordinator
