import requests


from infra.swatlib.httpclient import HttpClient, HttpClientException


class NannyError(HttpClientException):
    pass


class NannyClient(object):
    NANNY_API_URL = 'https://nanny.yandex-team.ru/'
    DEFAULT_REQ_TIMEOUT = 10  # seconds
    DEFAULT_VERIFY_SSL = True

    def __init__(self, url=None, token=None, req_timeout=None, verify_ssl=None,
                 max_retries=None):
        self.url = url or self.NANNY_API_URL
        req_timeout = req_timeout or self.DEFAULT_REQ_TIMEOUT
        token = token or None
        verify_ssl = self.DEFAULT_VERIFY_SSL if verify_ssl is None else verify_ssl
        self._client = HttpClient(
            client_name='nanny',
            exc_cls=NannyError,
            base_url=self.url,
            req_timeout=req_timeout,
            token=token,
            verify=verify_ssl,
            max_retries=max_retries
        )
        self.session = requests.Session()

    def get_service_instances(self, service_id):
        rel_url = 'v2/services/{}/runtime_attrs/instances/'.format(service_id)
        return self._client.get(rel_url)
