# -*- coding: utf-8 -*-

import logging
import flask
from collections import defaultdict

from flask import request, render_template, Blueprint, url_for, jsonify
from forms import GencfgQoutaForm, get_fields_from_form
from infra.yp_quota_distributor.lib.mongo import mongo_db
from bson.objectid import ObjectId
from infra.yp_quota_distributor.lib.args_parser import parse_args

from status import Status
from infra.yp_quota_distributor.lib.common import (
    create_new_request_or_display_user_history,
    get_all_dumped_groups
)
from infra.yp_quota_distributor.lib.constants import ERROR_STATUS_API_WITHOUT_REQUEST_ID
from infra.yp_quota_distributor.lib.qloud_quota import QloudQuota, dcs
from infra.yp.account_estimation import Account

gencfg_blueprint = Blueprint('gencfg_blueprint', __name__)


MODERATORS = ["glebskvortsov", "sereglond"]

args = parse_args()


logger = logging.getLogger(__name__)


@gencfg_blueprint.route('/approve/', methods=['GET'])
def approve():
    yandex_login = 'atridis' if args.no_cookie else request.cookies['yandex_login']
    if yandex_login not in MODERATORS:
        flask.abort(403)
    record_id = request.args.get('record_id')
    if not record_id:
        return render_template('error.html', text=ERROR_STATUS_API_WITHOUT_REQUEST_ID)
    collection = mongo_db["requests_queue"]
    record = collection.find_one({"_id": ObjectId(record_id)})
    if "stop_reason" in record:
        collection.update({"_id": record["_id"]}, {
            "$unset": {
                "stop_reason": 1
            },
            "$set": {
                "state": Status.GENCFG
            }
        })
        logger.info("Successfully approved request for record_id: {}".format(record["_id"]))
        return render_template(
            'info.html',
            info="You are successfully approved quota from this ticket:",
            ticket=record["ticket"],
            css_class="isa_success",
            main_url=url_for("index"))
    else:
        return render_template('info.html',
                               info="This request has already been processed",
                               ticket=record["ticket"],
                               css_class="isa_success")


@gencfg_blueprint.route('/', methods=['GET', 'POST'])
def index():
    print(args)
    yandex_login = 'atridis' if args.no_cookie else request.cookies['yandex_login']

    form = GencfgQoutaForm(yandex_login)
    redirect_url, render_data = create_new_request_or_display_user_history(
        request,
        'gencfg',
        'status',
        form,
        yandex_login,
        Status.START,
        get_fields_from_form
    )
    if redirect_url:
        return redirect_url

    return render_template('gencfg/templates/index.html', form=form, records=render_data)


def skip_ticket(ticket_key):
    blocked_tickets_collection = mongo_db["blocked_startrek_tickets"]
    is_blocked = blocked_tickets_collection.find_one({"_id": ticket_key})
    return is_blocked


@gencfg_blueprint.route('/stats')
def stats():
    existing_groups = get_all_dumped_groups()
    collection = mongo_db["completed_requests"]
    total_account_per_dc = defaultdict(Account.empty)
    open_migrations = []
    for record in collection.find({"type": "gencfg"}):
        if "stop_reason" in record:
            continue
        if "ticket" not in record:
            continue
        ticket_key = record["ticket"].split('/')[-1]
        if skip_ticket(ticket_key):
            continue
        if "unique_gencfg_groups_with_tags" not in record:
            print(record)
        groups = [item[0] for item in record["unique_gencfg_groups_with_tags"]]
        exist_flag = any(group in existing_groups for group in groups)
        account_per_dc = record["account_per_dc"]
        for dc in account_per_dc:
            account_per_dc[dc]["cpu"] /= 1000.
        if exist_flag:
            data = {
                "abc": record["abc_service_id"],
                "ticket": record["ticket"],
                "gencfg_groups": groups,
                "quota": account_per_dc
            }
            open_migrations.append(data)

            for dc, resources in account_per_dc.iteritems():
                total_account_per_dc[dc].add(
                    Account(resources["cpu"], resources["memory"], resources["ssd"], resources["hdd"], 0, 0, 0, 0)
                )
    for dc in total_account_per_dc:
        total_account_per_dc[dc] = total_account_per_dc[dc].__dict__
    total_quota = {"gencfg": QloudQuota()}
    total_quota["gencfg"].set_quota(total_account_per_dc)

    total_resources = QloudQuota.QLOUD_RESOURCES
    total_resources.append("hdd")
    for key, value in total_quota.iteritems():
        data = {}
        for resource in total_resources:
            item = {dc: value.quota[dc][resource] for dc in dcs}
            data[resource] = item
        total_quota[key] = data
    return jsonify({"openMigrations": open_migrations, "totalOpenMigrations": total_quota})
