from infra.yp_quota_distributor.lib.constants import VALID_MASTER_GROUPS


class Status():
    START = 0
    NANNY = 1
    GENCFG = 2
    ABC = 3
    STARTREK = 4
    DONE = 5

STATUS_INFO = {
    Status.START: "Your request is in the queue",
    Status.NANNY: "Getting gencfg groups by nanny services",
    Status.GENCFG: "Calculating quota for groups",
    Status.ABC: "Creating request to your abc service with calculated quota",
    Status.STARTREK: "Creating startrek ticket with full information",
    Status.DONE: "Your request was successfully handled"
}


class StopReason():
    NOTHING = 0
    UNSUPPORTED_DC = 1
    MASTER_GROUP = 2
    GUEST_GROUP = 3
    LARGE_VALUES = 4
    NOT_VALID_SLAVE_GROUP = 5
    BANNED_ABC_SERVICE = 6

STOP_REASON_INFO = {
    StopReason.UNSUPPORTED_DC: "Your gencfg groups have instances in unsupported DCs ('MSK': {}).",
    StopReason.MASTER_GROUP: "Your request has MASTER gencfg group.",
    StopReason.GUEST_GROUP: "Your request has GUEST gencfg group.",
    StopReason.LARGE_VALUES: "Your calculated quota is too high.",
    StopReason.NOT_VALID_SLAVE_GROUP: "Your request has SLAVE groups which master are not allowed. Allowed MASTER groups: {}.".format(','.join(VALID_MASTER_GROUPS)),
    StopReason.BANNED_ABC_SERVICE: "Current abc service was banned for yp quota distribution"
}
