# -*- coding: utf-8 -*-

from flask import request, Blueprint, jsonify, abort
import logging
import json

from infra.yp_quota_distributor.lib.args_parser import parse_args
from infra.yp_quota_distributor.lib.mongo import mongo_db
from infra.yp_quota_distributor.lib.constants import (
    STARTREK_URL,
    ABC_REMAPPING
)
from infra.yp_quota_distributor.lib.common import (
    add_record_fields,
    get_user_history,
    get_service_dump_by_name,
)

from status import Status

logger = logging.getLogger(__name__)


hosts_blueprint = Blueprint('hosts_blueprint', __name__)

args = parse_args()


def parse_request_data():
    data = request.form
    logger.info('{}'.format(data))
    return {
        'hosts': json.loads(data.get('field_1'))['value'].split(),
        'abc_segment': json.loads(data.get('field_2'))['value'],
        'abc_info': json.loads(data.get('field_3'))['value'],
        'debug': (json.loads(data.get('field_4'))['value'] == u"Да")
    }


@hosts_blueprint.route('/', methods=['POST', 'GET'])
def on_request():
    yandex_login = 'atridis' if args.no_cookie else request.headers.get('Login')

    if request.method == 'GET':
        ret_val = get_user_history(yandex_login, 'hosts')
        ret_val = [x[1] for x in ret_val]
        for item in ret_val:
            print(item)
            print('\n\n\n')
        return ''

    if request.method == 'POST':
        record = parse_request_data()

        abc_dump = get_service_dump_by_name(record.get("abc_info", ''), ABC_REMAPPING)
        if not abc_dump:
            abort(400)
        abc_service_id = abc_dump['service_id']
        abc_slug = abc_dump['slug'] if 'slug' in abc_dump else None
        record.update({
            "abc_slug": abc_slug,
            "abc_service_id": abc_service_id
        })
        record.update(add_record_fields(yandex_login, Status.START, 'hosts'))
        requests_collection = mongo_db['requests_queue']
        requests_collection.insert(record)
    return jsonify('Your request is being processed')


@hosts_blueprint.route('/tools/mytickets/', methods=['GET'])
def get_tickets():
    yandex_login = 'atridis' if args.no_cookie else request.cookies.get('yandex_login')
    yandex_login = request.args.get('login', yandex_login)
    if request.method == 'GET':
        cursor = mongo_db['requests_queue'].find({
            'yandex_login': yandex_login,
            'type': 'hosts'
        })
        tickets = list()
        for record in cursor:
            if 'main_ticket' in record.keys():
                tickets.append(STARTREK_URL + record['main_ticket'])
        if tickets:
            return jsonify({'your tickets': tickets})
        return jsonify('No tickets were found with your login')
    else:
        return 'Unknown request method'


@hosts_blueprint.route('/tools/test/', methods=['GET'])
def calculate_quota():
    abc = request.args.get('abc_slug', 'sdflkjasdlfkja')
    abc_dump = get_service_dump_by_name(abc, ABC_REMAPPING)
    abc_service_id = abc_dump['service_id']
    abc_slug = abc_dump['slug'] if 'slug' in abc_dump else None
    response = {
        'dump': abc_dump,
        'service_id': abc_service_id,
        'slug': abc_slug
    }
    return jsonify(response)
