import logging
import gevent.pywsgi as wsgi

from app import app
from infra.yp_quota_distributor.app.processes import (
    approve_abc_requests,
    operations,
    reject_duplicates,
    dump_services_info,
    handle_requests_queue,
    check_walle_scenarios
)
from infra.yp_quota_distributor.lib.log import (
    get_unified_agent_handler,
    get_file_handler
)

from multiprocessing import Process

from infra.yp_quota_distributor.lib.args_parser import parse_args

PROCESSES_FUNCTION = [
    dump_services_info.dump_info_into_db,
    handle_requests_queue.handle_request,
    # approve_abc_requests.approve_abc_requests,
    operations.notify_owners,
    reject_duplicates.reject_duplicates,
    check_walle_scenarios.check_walle_scenarios
]


logger = logging.getLogger('infra.yp_quota_distributor')


def main():
    args = parse_args()
    for func_process in PROCESSES_FUNCTION:
        process = Process(target=func_process)
        process.start()

    logger.addHandler(get_unified_agent_handler())
    logger.addHandler(get_file_handler())
    logger.setLevel(logging.DEBUG)
    logger.info('{} process started'.format(__name__))
    logger.info('Start server on port {}'.format(args.port))

    if args.debug:
        app.run(host='::', port=args.port, use_reloader=False, debug=True)
    else:
        wsgi.WSGIServer(('::', args.port), app).serve_forever()
