import time
import traceback
import random
import logging

from infra.yp_quota_distributor.lib.common import (
    abc_api,
    increase_unistat_signal_value,
)

from infra.yp_quota_distributor.lib.constants import (
    ROBOT_GENCFG,
    ROBOT_DISPENSER
)

from infra.yp_quota_distributor.lib.log import (
    get_unified_agent_handler,
    get_file_handler
)

approve_logger = logging.getLogger('infra.yp_quota_distributor')


def approve_abc_requests():
    approve_logger.addHandler(get_unified_agent_handler())
    approve_logger.addHandler(get_file_handler())
    approve_logger.setLevel(logging.DEBUG)
    approve_logger.info('{} process started'.format(__name__))
    while True:
        for robot in [ROBOT_GENCFG, ROBOT_DISPENSER]:
            try:
                response = abc_api.get_all_yp_resources('approved', robot)
                if response.ok:
                    results = response.json()["results"]
                    for item in results:
                        approve_logger.info("Approve request_id '{}' for ABC service: '{}'".format(item["id"], item["service"]))
                        abc_api.grant_quota_request(item["id"])
                time.sleep(0.5 + random.random() * 5)
            except Exception:
                increase_unistat_signal_value('approve-exceptions-number-total', 1)
                approve_logger.exception("Exception in approve_abc_requests: {}".format(traceback.format_exc()))
