from infra.yp_quota_distributor.lib.mongo import mongo_db
from infra.yp_quota_distributor.lib import walle_api_wrapper
from infra.yp_quota_distributor.lib.common import update_collection_record

from time import sleep


def check_walle_scenarios():
    while True:
        requests_queue_collection = mongo_db["requests_queue"]
        cursor = requests_queue_collection.find(
            filter={
                "type": "hosts",
                "scenarios_in_progress": 1,
                "walle_scenarios_finished": {
                    "$ne": 1
                }
            })
        records = [item for item in cursor]
        for record in records:
            if "walle_scenario_ids" in record.keys():
                status = "finished"
                if all([walle_api_wrapper.get_scenario(scenario)["status"] == status for scenario in record["walle_scenario_ids"]]):
                    update_collection_record(record["_id"], {"walle_scenarios_finished": 1})
        sleep(60)
