import time
import pymongo
import traceback
import datetime
import logging

from infra.yp_quota_distributor.lib.common import (
    increase_unistat_signal_value,
)
from infra.yp_quota_distributor.lib.log import (
    get_unified_agent_handler,
    get_file_handler
)
from infra.yp_quota_distributor.lib.mongo import mongo_db
from infra.yp_quota_distributor.app.gencfg.queue_worker import handle_record as gencfg_handler
from infra.yp_quota_distributor.app.qloud.queue_worker import handle_record as qloud_handler
from infra.yp_quota_distributor.app.hosts.queue_worker import handle_record as hosts_handler

from infra.yp_quota_distributor.lib.common import update_collection_record

handlers = {
    "gencfg": gencfg_handler,
    "qloud": qloud_handler,
    "hosts": hosts_handler
}

queue_worker_logger = logging.getLogger('infra.yp_quota_distributor')


def handle_request():
    queue_worker_logger.addHandler(get_unified_agent_handler())
    queue_worker_logger.addHandler(get_file_handler())
    queue_worker_logger.setLevel(logging.DEBUG)
    queue_worker_logger.info('{} process started'.format(__name__))
    while True:
        requests_queue_collection = mongo_db["requests_queue"]
        handling_records = mongo_db["handling_records"]
        cursor = requests_queue_collection.find(sort=[("lastUpdated", 1)]).limit(1)
        for record in cursor:
            if "type" in record:
                try:
                    requests_queue_collection.update(
                        {"_id": record["_id"]},
                        {"$set": {
                            "lastUpdated": datetime.datetime.now() + (int(record["state"]) if "state" in record else 10) * datetime.timedelta(minutes=2)
                        }})
                    handling_records.insert({"_id": record["_id"]})
                    queue_worker_logger.info("Process record with id {}".format(record["_id"]))
                    handlers[record["type"]](record)
                    handling_records.remove({"_id": record["_id"]})
                except pymongo.errors.DuplicateKeyError:
                    pass
                except Exception:
                    error_text = "Exception info for record_id {}: {}".format(
                        record["_id"], traceback.format_exc())
                    update_collection_record(record["_id"], {
                        "error_text": error_text,
                        "contact_login": "atridis"
                    })
                    increase_unistat_signal_value('request-exceptions-number-total', 1)
                    queue_worker_logger.exception(error_text)

        time.sleep(5)
