import logging
import random
import requests
import time
import traceback

from infra.yp_quota_distributor.lib.args_parser import parse_args

from infra.yp_quota_distributor.lib.abc_api import get_all_granted_resources
from infra.yp_quota_distributor.lib.common import (
    reject_duplicates_for_service,
    get_collection_by_type
)
from infra.yp_quota_distributor.lib.constants import (
    TOKEN,
    ROBOT_GENCFG,
    ABC_REMAPPING
)
from infra.yp_quota_distributor.lib.log import (
    get_unified_agent_handler,
    get_file_handler
)


logger = logging.getLogger('infra.yp_quota_distributor')


def reject_duplicates():
    logger.addHandler(get_unified_agent_handler())
    logger.addHandler(get_file_handler())
    logger.setLevel(logging.DEBUG)
    logger.info('{} process started'.format(__name__))
    args = parse_args()
    if args.test:
        logger.info("Testing environment doesn't reject resources")
        time.sleep(2)
        return

    session = requests.Session()
    session.headers['Authorization'] = 'OAuth {}'.format(TOKEN)

    while True:
        try:
            abc_remapping_collection = get_collection_by_type(ABC_REMAPPING)
            service_ids = set()
            for record in abc_remapping_collection.find():
                service_ids.add(record['service_id'])
            for service_id in service_ids:
                results = []
                try:
                    results = get_all_granted_resources(service_id=service_id, register=ROBOT_GENCFG)
                except Exception:
                    logger.exception(
                        "Exception int reject_duplicates service_id {}. Error: {}".format(
                            service_id,
                            traceback.format_exc())
                        )
                    pass
                reject_duplicates_for_service(service_id, results)

            time.sleep(3 * 60 * 60 + random.random() * 100)
        except Exception:
            logger.exception("Exception while rejecting duplicates: {}".format(traceback.format_exc()))
