# -*- coding: utf-8 -*-

import json
import copy
import datetime
import logging


from flask import request, render_template, url_for, redirect, Blueprint, jsonify, abort
from forms import QloudQoutaForm, RevertForm
from infra.yp_quota_distributor.lib.args_parser import parse_args
from infra.yp_quota_distributor.lib.constants import TOKEN, ADMINS, STARTREK_URL

from infra.yp_quota_distributor.lib.qloud_api import QloudApi
from infra.yp_quota_distributor.lib.mongo import mongo_db

from status import Status
from forms import get_fields_from_form
from infra.yp_quota_distributor.lib.common import (
    get_user_history,
    add_record_fields
)
from infra.yp_quota_distributor.lib.qloud_quota import (
    get_free_qloud_quota,
    parse_qloud_quota,
    default_quota,
    QloudQuotaTable,
    QloudQuota,
    dcs
)

from lock_qloud_project import (
    is_project_locked,
    lock_project,
    release_project,
    get_lock_login
)

# encoding=utf8
import sys
reload(sys)
sys.setdefaultencoding('utf8')

qloud_blueprint = Blueprint(
    'qloud_blueprint', __name__, template_folder='templates')

args = parse_args()


# Thread safe (lock is acquired)
def update_qloud_not_allocated_delta(record, remove_flag=False):
    qloud_key = record["qloud_project_url"]

    qloud_quota_collection = mongo_db["qloud_quota"]
    cursor = qloud_quota_collection.find_one({"_id": qloud_key})
    if not cursor:
        qloud_quota_collection.insert({
            "_id": qloud_key,
            "delta_tables": {},
            "allocated_tables": {}})
        while not cursor:
            cursor = qloud_quota_collection.find_one({"_id": qloud_key})

    tables = cursor["delta_tables"]
    for table_dict in record["tables"]:
        table = QloudQuotaTable(table_dict)
        table.quota.float_all_values()
        segment_id = table.id
        if segment_id.endswith("_editable"):
            if table.segment in tables:
                prev_table = QloudQuotaTable(tables[table.segment])
                prev_table.quota.float_all_values()
                if remove_flag:
                    prev_table.quota.remove(table.quota)
                    table = copy.deepcopy(prev_table)
                else:
                    table.quota.add(prev_table.quota)
            tables[table.segment] = table.to_json()

    qloud_quota_collection.update({"_id": qloud_key},
                                  {"$set": {
                                      "delta_tables": tables
                                  }})


@qloud_blueprint.route('/', methods=['GET', 'POST'])
def index():
    yandex_login = 'atridis' if args.no_cookie else request.cookies['yandex_login']

    form = QloudQoutaForm(yandex_login)
    show_quota = False
    tables_info = []
    table_balancer_quota = QloudQuotaTable({"id": "table_balancer_quota_editable", "caption": '???'}, for_balancer=True)
    records = get_user_history(yandex_login, "qloud")
    error_text = ""
    qloud_project_url = ""
    if request.method == 'POST':
        qloud_project = form.qloud_project_key.data.encode("utf-8")
        qloud_project_url = "{}projects/{}".format(
            form.qloud_env.data, form.qloud_project_key.data)
        if 'show_project_info' in request.form:
            if form.custom_validate_qloud_project():
                end_time = datetime.datetime.now() + datetime.timedelta(minutes=15)
                flag, minutes = lock_project(qloud_project_url, yandex_login, end_time)
                if flag:
                    show_quota = True
                    qloud_client = QloudApi(form.qloud_env.data, TOKEN)
                    r = qloud_client.get_quota_for_project(qloud_project)
                    max_qloud_quota = parse_qloud_quota(r.json())
                    # TODO: if there is tables not calculate again and use value from form

                    for item in max_qloud_quota:
                        max_table = QloudQuotaTable(item)
                        max_table = get_free_qloud_quota(qloud_project_url, max_table)
                        cur_table = copy.deepcopy(max_table)

                        max_table.id += "_current"

                        cur_table.id += '_editable'
                        cur_table.quota.update(default_quota())
                        cur_table.caption = u'Migrate quota to YP'

                        tables_info.append(max_table)
                        tables_info.append(cur_table)

                    tables_info = [item.to_json() for item in tables_info]
                else:
                    error_text = "This qloud project is being processed by {}. Please wait {} minutes.".format(
                        get_lock_login(qloud_project_url), minutes + 1)
        elif 'issue_quota' in request.form:
            show_quota = True
            record = get_fields_from_form(form)
            tables_info = record["tables"]
            table_balancer_quota = QloudQuotaTable({"id": "table_balancer_quota_editable", "caption": '???'}, for_balancer=True)
            if "table_balancer_quota" in record and len(record["table_balancer_quota"]) > 0:
                table_balancer_quota = QloudQuotaTable(record["table_balancer_quota"][0], for_balancer=True)

            requests_collection = mongo_db["requests_queue"]

            if yandex_login == get_lock_login(qloud_project_url) and is_project_locked(qloud_project_url):
                if form.validate_on_submit():
                    record.update(add_record_fields(yandex_login, Status.START, "qloud"))

                    update_qloud_not_allocated_delta(record)
                    requests_collection.insert(record)
                    release_project(qloud_project_url)
                    return redirect(
                        url_for('status') +
                        '?record_id={}'.format(record['_id'])), []
                else:
                    logging.warn(
                        "Yandex login: {}. Expect GET request or POST with valid from"
                        .format(yandex_login))
            else:
                show_quota = False
                error_text = "You have been inactive for too long. To avoid problems, start again."
        else:
            print("WHAT?!")
    print("\n" * 2)
    tables_info = sorted(tables_info, key=lambda x: x["id"])
    form.tables.data = json.dumps(tables_info)
    form.table_balancer_quota.data = json.dumps([table_balancer_quota.to_json()])
    return render_template('qloud/templates/index.html',
                           show_quota=show_quota,
                           qloud_quota_form=form,
                           tables_info=tables_info,
                           qloud_project_url=qloud_project_url,
                           records=records,
                           main_url=url_for('index'),
                           error_text=error_text,
                           show_balancer=True)


@qloud_blueprint.route('/stats/')
def stats():
    open_migrations = []
    total_migrations = {"qloud": QloudQuota(), "qloud-ext": QloudQuota()}
    collection = mongo_db["completed_requests"]
    for record in collection.find({"type": "qloud"}):
        if "remove_pending_account_per_dc" in record:
            continue
        qloud_env = record["qloud_project_url"].split("//")[1].split(".")[0]
        data = {
            "abc": record["abc_service_id"],
            "qloud-project": record["qloud_project"],
            "qloud-env": qloud_env,
        }
        for segment, value in record["segments_account_per_dc"].iteritems():
            for dc, quota in value.iteritems():
                new_data = copy.deepcopy(data)
                new_data["qloud-segment"] = segment
                new_data["cluster"] = dc
                new_data["quota"] = quota
                if any(v != 0 for v in quota.values()):
                    open_migrations.append(new_data)
            qloud_quota = QloudQuota()
            qloud_quota.set_quota(value)
            total_migrations[data["qloud-env"]].add(qloud_quota)
    total_resources = QloudQuota.QLOUD_RESOURCES
    total_resources.append("hdd")
    for key, value in total_migrations.iteritems():
        data = {}
        for resource in total_resources:
            item = {dc: value.quota[dc][resource] for dc in dcs}
            data[resource] = item
        total_migrations[key] = data
    response = {"openMigrations": open_migrations, "totalOpenMigrations": total_migrations}
    return jsonify(response)


@qloud_blueprint.route('/revert_quota/', methods=['GET', 'POST'])
def revert_quota():
    yandex_login = 'atridis' if args.no_cookie else request.cookies['yandex_login']
    if yandex_login not in ADMINS:
        abort()
    form = RevertForm(yandex_login)
    if request.method == 'POST' and form.validate_on_submit():
        completed_requests = mongo_db["completed_requests"]
        record = completed_requests.find_one({"ticket": STARTREK_URL + form.ticket_key.data.encode("utf-8")})
        qloud_project_url = record["qloud_project_url"]

        end_time = datetime.datetime.now() + datetime.timedelta(minutes=15)
        if lock_project(qloud_project_url, yandex_login, end_time):
            update_qloud_not_allocated_delta(record, remove_flag=True)
            completed_requests.remove({"_id": record["_id"]})
            release_project(qloud_project_url)
            return json.dumps({'success': True}), 200, {'ContentType': 'application/json'}
        else:
            return json.dumps({'success': False, 'error': 'Project is locked'}), 500, {'ContentType': 'application/json'}

    return render_template('qloud/templates/revert_quota.html',
                           form=form,
                           main_url=url_for('index'))
