import pymongo
import datetime

from infra.yp_quota_distributor.lib.mongo import mongo_db

MONGO_KEY = "handling_qloud_projects"


def is_project_locked(qloud_project_url):
    record = mongo_db[MONGO_KEY].find_one({"_id": qloud_project_url})
    cur_time = datetime.datetime.now()
    if record:
        return (cur_time < record["endTime"]), ((record["endTime"] - cur_time).seconds % 3600) // 60
    return False, 0


def lock_project(qloud_project_url, login, end_time):
    flag, minutes = is_project_locked(qloud_project_url)
    if not flag:
        try:
            mongo_db[MONGO_KEY].insert({"_id": qloud_project_url, "endTime": end_time, "login": login})
        except pymongo.errors.DuplicateKeyError:
            mongo_db[MONGO_KEY].update({"_id": qloud_project_url}, {"$set": {"endTime": end_time, "login": login}})
        except Exception as e:
            raise(e)
        return True, 0
    else:
        return False, minutes


def release_project(qloud_project_url):
    # time
    if is_project_locked(qloud_project_url)[0]:
        mongo_db[MONGO_KEY].remove({"_id": qloud_project_url})
        return False
    else:
        return True


def get_lock_login(qloud_project_url):
    record = mongo_db[MONGO_KEY].find_one({"_id": qloud_project_url})
    if record:
        return record["login"]
    return None
