function jtGetItem(obj, key) {
    var fieldData = '';

    if(obj[key].constructor === Array) {
        fieldData = '[';
        for(var j = 0; j < obj[key].length; j++) {
            if(fieldData !== '[') {
                fieldData += ', ';
            }
            fieldData += jtGetItem(obj[key], j);
        }
        fieldData += ']'
    } else if(obj[key].constructor === Object) {
        fieldData = '{';
        for(var name in obj[key]) {
            if(fieldData !== '{') {
                fieldData += ', ';
            }
            fieldData +=  name + ' : ' + jtGetItem(obj[key], name);
        }
        fieldData += '}';
    } else if(obj[key].constructor === String || obj[key].constructor === Number) {
        fieldData += obj[key];
    } else {
        fieldData += 'none';
    }

    return fieldData;
}

function jtParseItem(value) {
    if(value.startsWith('{') && value.endsWith('}')) {
        var fieldData = {};

        var slicedValue = value.slice(1, -1);
        var list_items = slicedValue.split(',');
        for(var i = 0; i < list_items.length; i++) {
            var key_val = list_items[i].split(' : ');
            var data = jtParseItem(key_val[1]);
            if(data !== '') {
                fieldData[key_val[0]] = data;
            }
        }
        return fieldData;
    } else if(value.startsWith('[') && value.endsWith(']')) {
        var fieldData = [];

        var slicedValue = value.slice(1, -1);
        var list_items = slicedValue.split(',');
        for(var i = 0; i < list_items.length; i++) {
            var data = jtParseItem(list_items[i]);
            if(data !== '') {
                fieldData.push(data);
            }
        }
        return fieldData
    } else {
        return value.trim();
    }
}

function jtClear(tableId) {
    var $tableBody = $("#" + tableId).find('tbody');
    $tableBody.find('tr').remove();
}

function jtFillJson(tableId, jsonData) {
    var $tableHead = $("#" + tableId).find('thead');
    var $tableBody = $("#" + tableId).find('tbody');
    $tableBody.find('tr').remove();

    for(var i = 0; i < jsonData.length; i++) {
        var row = jsonData[i];
        var $clonedRow = $tableHead.find('tr.header').clone(true).removeClass('header');

        for(var fieldName in row) {
            var value = jtGetItem(row, fieldName);
            var $clonedRowItem = $clonedRow.find('td[name=' + fieldName +']')

            if($clonedRowItem.attr('class') !== undefined &&
                    $clonedRowItem.attr('class').split(' ').includes('editable')) {
                $clonedRowItem.attr('contenteditable', 'true');
            }
            $clonedRowItem.text(value);
        }

        $tableBody.append($clonedRow)
    }

}

function jtFill(tableId, jsonRawData) {
    var jsonData = JSON.parse(jsonRawData);
    jtFillJson(tableId, jsonData);
}

function jtRead(tableId) {
    var $tableHead = $("#" + tableId).find('thead');
    var $tableBody = $("#" + tableId).find('tbody');
    var $tableRows = $tableBody.find('tr');

    // Turn all existing rows into a loopable array
    var tableData = [];
    $tableRows.each(function () {
        var $tableTds = $(this).find('td');

        var rowData = {};
        $tableTds.each(function () {
            var filedName = $(this).attr('name');
            var fieldValue = jtParseItem($(this).text());

            if(filedName !== "jtAction" && filedName !== undefined) {
                rowData[filedName] = fieldValue;
            }
        });
        tableData.push(rowData);
    });

    // return JSON.stringify(tableData);
    return tableData;
}

function jtQuotaDataFillByClass(tableClass, formItemName, formId, is_segment) {
    var tables = document.getElementsByClassName(tableClass);
    var len = tables.length;
    var $form = $("#" + formId);
    var $tableJtData = $form.find('textarea.jtData_' + formItemName);
    if($tableJtData.html() === undefined) {
        $form.append('<textarea style="display: none;" class="jtData_' + formItemName + '"></textarea>');
        $tableJtData = $form.find('textarea.jtData_' + formItemName);
        $tableJtData.attr('name', formItemName);
    }
    var resultData = [];
    for (var i = 0; i < len; ++i) {
        var tableId = tables[i].id;
        var currentData = jtRead(tableId);
        if (is_segment) {
            resultData.push({
                'quota': currentData,
                'id': tableId,
                'caption': tables[i].caption.textContent,
                'segment': tableId.split("_")[0]
            });
        } else {
            resultData.push({
                'quota': currentData,
                'id': tableId,
                'caption': tables[i].caption.textContent
            });
        }
    }
    $tableJtData.html(JSON.stringify(resultData));
}

function jtAddNewLine(tableId) {
    var $tableHead = $("#" + tableId).find('thead');
    var $tableBody = $("#" + tableId).find('tbody');
    var $clonedRow = $tableHead.find('tr.header').clone(true).removeClass('header');

    $clonedRow.find('td').each(function () {
        if($(this).attr('class') !== undefined &&
                $(this).attr('class').split(' ').includes('editable')) {
            $(this).attr('contenteditable', 'true');
        }
        $(this).text($(this).attr('placeholder'));
    });

    $tableBody.append($clonedRow)
}

function jtDelLine(tableId, index) {
    var $tableHead = $("#" + tableId).find('thead')
    var $tableBody = $("#" + tableId).find('tbody');
    var $tableRows = $tableBody.find('tr:not(:hidden)');

    $tableRows[index].remove();
}

function jtFillQuotaTablesByJson(jsonData) {
    var len = jsonData.length;
    for (var i = 0; i < len; ++i) {
        jtFillJson(jsonData[i]['id'], jsonData[i]['quota']);
    }
}
