import datetime
from infra.yp_quota_distributor.lib.mongo import mongo_db


def configure_data_for_tickets_collecion(ticket, groups, logins):
    return {
        "_id": ticket,
        "data": {
            "logins": logins,
            "time": datetime.datetime.now(),
            "gencfg_groups": groups
        }
    }


def configure_data_for_groups_collecion(group, ticket, logins):
    return {
        "_id": group,
        "data": {
            "login": logins[0],
            "time": datetime.datetime.now(),
            "ticket": ticket
        }
    }


def add_groups(ticket, groups, logins, quota):
    groups_collection = mongo_db["unique_gencfg_groups"]
    tickets_collection = mongo_db["handling_startrek_tickets"]
    tickets_collection.insert(configure_data_for_tickets_collecion(ticket, groups, logins))
    for group in groups:
        groups_collection.insert(configure_data_for_groups_collecion(group, ticket, logins))
