from infra.yp_quota_distributor.lib.common import (
    create_yp_quota_request_for_abc_service,
    get_ticket_for_banned_service,
    is_abc_service_banned
)


def allocate_abc_quota(session, service_id, data):
    if is_abc_service_banned(service_id):
        raise Exception("Service is banned. More info here: {}".format(get_ticket_for_banned_service(service_id)))
        return
    for quota in data:
        create_yp_quota_request_for_abc_service(session, service_id, quota)
