import argparse

from infra.yp_quota_distributor.lib.mongo import mongo_db


def delete_groups(groups, groups_collection, tickets_collection, blocked_tickets_collection):
    tickets = []
    for group in groups:
        cursor = groups_collection.find_one({"_id": group})
        if cursor:
            ticket_key = cursor['data']['ticket'].strip('/').split('/')[-1]
            tickets.append(ticket_key)
            try:
                tickets_collection.remove({"_id": ticket_key})
                groups_collection.remove({"_id": group})
            except:
                pass
    block_tickets(tickets, blocked_tickets_collection, False)
    print("Successfully delete wrong handled groups: {}".format(groups))


def block_tickets(tickets, blocked_tickets_collection, print_info=True):
    for ticket in tickets:
        try:
            blocked_tickets_collection.insert({"_id": ticket})
        except:
            pass
    if print_info:
        print("Successfully block {}".format(tickets))


def delete_wrong_handled_groups(argv):
    def parse_args(cur_argv):
        parser = argparse.ArgumentParser(add_help=True)
        parser.add_argument('--gencfg-groups', required=True, help='Gencfg groups which was wrong handled')
        parser.add_argument('--block-tickets', required=False, help='Tickets which will be blocked')
        return parser.parse_args(cur_argv)

    args = parse_args(argv)
    groups = args.gencfg_groups
    tickets = args.block_tickets

    def get_data_from_string(line):
        return line.strip(",").split(",")

    handled_groups_collection = mongo_db["unique_gencfg_groups"]
    tickets_collection = mongo_db["handling_startrek_tickets"]
    blocked_tickets_collection = mongo_db["blocked_startrek_tickets"]
    delete_groups(get_data_from_string(groups), handled_groups_collection, tickets_collection, blocked_tickets_collection)
    if tickets:
        block_tickets(get_data_from_string(tickets), blocked_tickets_collection)
