import argparse
import pprint

from infra.yp_quota_distributor.lib.mongo import mongo_db

ST_TICKET_TEMPLATE = "https://st.yandex-team.ru/{}"


def _add_to_result(result, ticket, collection):
    for key in ["ticket", "_id"]:
        data = collection.find({key: ticket})
        for item in data:
            result.update(item)


def get_ticket_info(argv):
    def parse_args(cur_argv):
        parser = argparse.ArgumentParser(add_help=True)
        parser.add_argument('--ticket', required=True, help='Information will be provided about this ticket')
        return parser.parse_args(cur_argv)

    args = parse_args(argv)
    result = {}
    for ticket in [args.ticket, ST_TICKET_TEMPLATE.format(args.ticket)]:
        for collection in [mongo_db["requests_queue"], mongo_db["handling_startrek_tickets"]]:
            _add_to_result(result, ticket, collection)

    pp = pprint.PrettyPrinter(indent=4)
    pp.pprint(result)
